/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dataimport.ActionChooserScreen;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.RunnableImportProcess;
import fi.csc.microarray.client.dataimport.table.InformationDialog;
import fi.csc.microarray.client.dialog.TaskImportDialog;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ImportUtils {
    private static final String PREPROCESS_TOOL_ID = "LocalNGSPreprocess.java";
    private static final Logger logger = Logger.getLogger(ImportUtils.class);
    private static final String DEFAULT_FOLDER_NAME = "";
    private static ClientApplication application = Session.getSession().getApplication();

    public static JFileChooser getFixedFileChooser() {
        return ImportUtils.getFixedFileChooser(null);
    }

    public static JFileChooser getFixedFileChooser(File file) {
        JFileChooser fileChooser = file != null ? new JFileChooser(file) : new JFileChooser();
        fileChooser.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        return fileChooser;
    }

    public static Set<String> getFolderNames(boolean includeDefaultFolder) {
        HashSet<String> folderNameList = new HashSet<String>();
        DataFolder root = application.getDataManager().getRootFolder();
        for (DataItem item : root.getChildren()) {
            if (!(item instanceof DataFolder)) continue;
            folderNameList.add(item.getName());
        }
        if (includeDefaultFolder) {
            folderNameList.add(DEFAULT_FOLDER_NAME);
        }
        return folderNameList;
    }

    public static URLFileLoader getURLFileLoader() {
        return new URLFileLoader();
    }

    public static File createTempFile(String name, String ext) throws IOException {
        File file = File.createTempFile(name, ext);
        file.deleteOnExit();
        return file;
    }

    public static boolean containsUnsupportedTypes(File[] files) {
        boolean isUnsupported = false;
        for (File file : files) {
            if (ImportUtils.isFileSupported(file)) continue;
            isUnsupported = true;
        }
        return isUnsupported;
    }

    public static boolean isFileSupported(File file) {
        return application.getDataManager().guessContentType(file).isSupported();
    }

    public static String getExtension(String fileName) {
        if (fileName.contains(".")) {
            return fileName.substring(fileName.indexOf(46), fileName.length());
        }
        return DEFAULT_FOLDER_NAME;
    }

    public static String URLToFilename(URL url) {
        String fileName = url.getFile().substring(url.getFile().lastIndexOf("/") + 1, url.getFile().length());
        if (fileName.length() < 3) {
            fileName = "url_" + fileName;
        }
        return fileName;
    }

    public static void executeImport(ImportSession importSession) {
        if (!application.isStandalone()) {
            List<File> files = importSession.getInputFiles();
            boolean allBamSamOrBed = true;
            for (File file : files) {
                if (file.getName().toLowerCase().endsWith(".bam") || file.getName().toLowerCase().endsWith(".bai") || file.getName().toLowerCase().endsWith(".sam") || file.getName().toLowerCase().endsWith(".bed") || file.getName().toLowerCase().endsWith(".gtf") || file.getName().toLowerCase().endsWith(".vcf")) continue;
                allBamSamOrBed = false;
                break;
            }
            if (allBamSamOrBed) {
                ImportUtils.openPreprocessDialog(importSession);
            } else {
                boolean importToolSupported = Session.getSession().getPrimaryModule().isImportToolSupported();
                if (!importToolSupported || importSession.isSkipActionChooser() && !ImportUtils.containsUnsupportedTypes(files.toArray(new File[files.size()]))) {
                    application.importGroup(importSession.getImportItems(), importSession.getDestinationFolder());
                } else {
                    new ActionChooserScreen(importSession);
                }
            }
        } else if (importSession.isSkipActionChooser()) {
            application.importGroup(importSession.getImportItems(), importSession.getDestinationFolder());
        } else {
            ImportUtils.openPreprocessDialog(importSession);
        }
    }

    private static void openPreprocessDialog(ImportSession importSession) {
        try {
            LinkedList<DataBean> inputBeans = new LinkedList<DataBean>();
            int i = 0;
            for (File inputFile : importSession.getInputFiles()) {
                inputBeans.add(Session.getSession().getDataManager().createDataBean("preprocessInput-" + i, inputFile));
                ++i;
            }
            ClientApplication application = Session.getSession().getApplication();
            Operation importOperation = new Operation(application.getOperationDefinition(PREPROCESS_TOOL_ID), inputBeans.toArray(new DataBean[0]));
            new TaskImportDialog(application, "Preprocess NGS data", importSession, importOperation, "Preprocess", "Cancel", "Skip preprocessing", "Please note that preprocessing SAM and BAM files can take several minutes depending on the file size.");
        }
        catch (Exception me) {
            Session.getSession().getApplication().reportException(me);
        }
    }

    public static class FileLoaderImportProcess
    extends FileLoaderProcess {
        protected String importFolder;
        protected boolean skipActionChooser;

        public FileLoaderImportProcess(File outputFile, URL url, String importFolder, InformationDialog info, boolean skipActionChooser) {
            super(outputFile, url, info);
            this.importFolder = importFolder;
            this.skipActionChooser = skipActionChooser;
        }

        @Override
        protected void postProcess() {
            ImportUtils.executeImport(new ImportSession(ImportSession.Source.URL, new File[]{this.outputFile}, this.importFolder, this.skipActionChooser));
        }
    }

    public static class FileLoaderProcess
    extends RunnableImportProcess {
        protected File outputFile;
        protected URL url;
        protected InformationDialog info;

        public FileLoaderProcess(File outputFile, URL url, InformationDialog info) {
            super(info);
            this.outputFile = outputFile;
            this.url = url;
            this.info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void taskToDo() {
            HttpURLConnection connection;
            block10: {
                connection = null;
                try {
                    int numRead;
                    connection = (HttpURLConnection)this.url.openConnection();
                    this.info.setMinimunValue(0);
                    this.info.setMaximumValue(connection.getContentLength());
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                    InputStream in = connection.getInputStream();
                    byte[] buffer = new byte[1024];
                    int numWritten = 0;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        this.info.setValue(numWritten += numRead);
                    }
                    out.close();
                    if (numWritten > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FileLoaderProcess.this.postProcess();
                            }
                        });
                        break block10;
                    }
                    JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "Length of the loaded file is zero, import aborted", "File size too small", 0);
                }
                catch (IOException e) {
                    block11: {
                        if (e instanceof FileNotFoundException) {
                            JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "File from the typed url can't be found", "File not found", 0);
                            break block11;
                        }
                        if (e instanceof UnknownHostException) {
                            JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "Host from the typed url can't be found", "Host not found", 0);
                            break block11;
                        }
                        application.reportException(e);
                    }
                    IOUtils.disconnectIfPossible(connection);
                }
                catch (IllegalArgumentException e2) {
                    JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "Malformed URL, correct URL form is http://www.host.com/file.ext", "Malformed URL", 0);
                    {
                        catch (Throwable throwable) {
                            IOUtils.disconnectIfPossible(connection);
                            throw throwable;
                        }
                    }
                    IOUtils.disconnectIfPossible(connection);
                }
            }
            IOUtils.disconnectIfPossible(connection);
        }

        protected void postProcess() {
        }
    }

    public static class URLFileLoader {
        public File loadFileFromURL(URL url, File outputFile, String importFolder, boolean skipActionChooser) {
            logger.debug((Object)"Method loadFileFromURL started");
            InformationDialog info = new InformationDialog("Loading file", "Loading file from the specified URL", null);
            logger.debug((Object)"Next the download process will start");
            new FileLoaderImportProcess(outputFile, url, importFolder, info, skipActionChooser).runProcess();
            logger.debug((Object)"Download process started");
            return outputFile;
        }
    }
}

