/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb.ui;

import com.vaadin.data.Property;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import fi.csc.chipster.web.adminweb.ui.DateColumnGenerator;
import fi.csc.chipster.web.adminweb.ui.JobLogView;
import fi.csc.chipster.web.adminweb.util.StringUtils;

public class JobLogTable
extends Table {
    private JobLogView view;

    public JobLogTable(JobLogView view) {
        this.view = view;
        this.setSizeFull();
        this.setWidth("100%");
        this.setSelectable(true);
        this.setImmediate(true);
        this.addGeneratedColumn("startTime", new DateColumnGenerator());
        this.addGeneratedColumn("wallclockTime", new WallClockColumnGenerator());
        this.addGeneratedColumn("outputLink", new OutputLinkColumnGenerator());
        this.addGeneratedColumn("errorLink", new ErrorLinkColumnGenerator());
    }

    class ErrorLinkColumnGenerator
    implements Table.ColumnGenerator {
        ErrorLinkColumnGenerator() {
        }

        public Component generateCell(Table source, final Object itemId, Object columnId) {
            String errorMessage;
            Property prop = source.getItem(itemId).getItemProperty((Object)"errorMessage");
            if (prop != null && prop.getType() != null && prop.getType().equals(String.class) && (errorMessage = (String)prop.getValue()) != null) {
                Button link = new Button();
                link.setIcon((Resource)new ThemeResource("../admin/crystal/agt_update_critical.png"));
                link.setStyleName("link");
                link.setDescription("Show job error message");
                link.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent event) {
                        JobLogTable.this.select(itemId);
                        JobLogTable.this.view.showErrorOutput(itemId);
                    }
                });
                return link;
            }
            return null;
        }
    }

    class OutputLinkColumnGenerator
    implements Table.ColumnGenerator {
        OutputLinkColumnGenerator() {
        }

        public Component generateCell(Table source, final Object itemId, Object columnId) {
            Button link = new Button("Output");
            link.setStyleName("link");
            link.setDescription("Show job output");
            link.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    JobLogTable.this.select(itemId);
                    JobLogTable.this.view.showOutput(itemId);
                }
            });
            return link;
        }
    }

    class WallClockColumnGenerator
    implements Table.ColumnGenerator {
        WallClockColumnGenerator() {
        }

        public Component generateCell(Table source, Object itemId, Object columnId) {
            Property prop = source.getItem(itemId).getItemProperty(columnId);
            if (prop != null && prop.getType() != null && prop.getType().equals(Integer.class)) {
                Integer wallClockTime = (Integer)prop.getValue();
                Label label = new Label(StringUtils.formatMinutes(wallClockTime));
                return label;
            }
            return null;
        }
    }
}

