/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.draw.Wizard;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.gui.AdvancedOptions;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.LaunchJalView;
import org.emboss.jemboss.gui.SequenceData;
import org.emboss.jemboss.gui.SequenceList;
import org.emboss.jemboss.gui.ShowSavedResults;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.ServerSetup;

public class SetUpMenuBar {
    public static SequenceList seqList;
    public static LocalAndRemoteFileTreeFrame localAndRemoteTree;
    private JMenuItem showLocalRemoteFile;
    private JMenuItem fileMenuShowres;
    private ServerSetup ss = null;
    private AdvancedOptions ao;
    private JMenu favMenu;

    public SetUpMenuBar(final JembossParams jembossParams, final JFrame jFrame, final boolean bl) {
        final Cursor cursor = new Cursor(3);
        final Cursor cursor2 = new Cursor(0);
        JMenuBar jMenuBar = new JMenuBar();
        new BoxLayout(jMenuBar, 0);
        jMenuBar.add(Box.createRigidArea(new Dimension(5, 24)));
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        if (bl) {
            this.fileMenuShowres = new JMenuItem("Saved Results");
            this.fileMenuShowres.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.setCursor(cursor);
                    new ShowSavedResults(jembossParams, jFrame);
                    jFrame.setCursor(cursor2);
                }
            });
            jMenu.add(this.fileMenuShowres);
            this.showLocalRemoteFile = new JMenuItem("Local and Remote Files");
            this.showLocalRemoteFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.setCursor(cursor);
                    if (localAndRemoteTree == null) {
                        try {
                            localAndRemoteTree = new LocalAndRemoteFileTreeFrame(jembossParams);
                            Dimension dimension = jFrame.getToolkit().getScreenSize();
                            int n = (int)(dimension.getHeight() - (double)localAndRemoteTree.getHeight()) / 2;
                            int n2 = (int)localAndRemoteTree.getPreferredSize().getWidth();
                            int n3 = jFrame.getWidth();
                            n2 = (int)dimension.getWidth() - n2;
                            if (n3 < n2) {
                                n2 = n3;
                            }
                            localAndRemoteTree.setLocation(n2, n);
                            localAndRemoteTree.setVisible(true);
                        }
                        catch (JembossSoapException jembossSoapException) {
                            localAndRemoteTree = null;
                            AuthPopup authPopup = new AuthPopup(jembossParams, jFrame);
                            authPopup.setBottomPanel();
                            authPopup.setSize(380, 170);
                            authPopup.pack();
                            authPopup.setVisible(true);
                        }
                    } else {
                        localAndRemoteTree.setVisible(true);
                    }
                    jFrame.setCursor(cursor2);
                }
            });
            jMenu.add(this.showLocalRemoteFile);
            jMenu.addSeparator();
        }
        this.ao = new AdvancedOptions(jembossParams);
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetUpMenuBar.this.exitJemboss();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Preferences");
        jMenu2.setMnemonic(80);
        JMenuItem jMenuItem2 = new JMenuItem("Advanced Options");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane jOptionPane = new JOptionPane();
                JOptionPane.showMessageDialog(jFrame, SetUpMenuBar.this.ao, "Advanced Options", -1);
            }
        });
        jMenu2.add(jMenuItem2);
        jMenu2.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Settings");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (SetUpMenuBar.this.ss == null) {
                    SetUpMenuBar.this.ss = new ServerSetup(jembossParams, bl);
                }
                if ((n = JOptionPane.showConfirmDialog(jFrame, SetUpMenuBar.this.ss, "Jemboss Settings", 2, -1, null)) == 0 && bl) {
                    SetUpMenuBar.this.ss.setNewSettings();
                }
            }
        });
        jMenu2.add(jMenuItem3);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Tools");
        jMenu3.setMnemonic(84);
        JMenuItem jMenuItem4 = new JMenuItem("Multiple Sequence Editor - Jemboss");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlignJFrame alignJFrame = new AlignJFrame();
                alignJFrame.setVisible(true);
            }
        });
        jMenu3.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Multiple Sequence Editor - Jalview");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new LaunchJalView();
            }
        });
        jMenu3.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Jemboss DNA Editor");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard wizard = new Wizard(null);
                DNADraw dNADraw = wizard.getDNADraw();
                JFrame jFrame = new JFrame("DNA Viewer");
                Dimension dimension = jFrame.getToolkit().getScreenSize();
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                Vector vector3 = new Vector();
                Vector vector4 = new Vector();
                if (dNADraw == null) {
                    dNADraw = new DNADraw(vector, vector2, vector3, vector4);
                }
                DNADraw.jsp = new JScrollPane(dNADraw);
                DNADraw.jsp.getViewport().setBackground(Color.white);
                dNADraw.setCloseAndDispose(true, jFrame);
                jFrame.getContentPane().add(DNADraw.jsp);
                jFrame.setJMenuBar(dNADraw.createMenuBar());
                jFrame.pack();
                jFrame.setLocation(((int)dimension.getWidth() - jFrame.getWidth()) / 4, ((int)dimension.getHeight() - jFrame.getHeight()) / 2);
                jFrame.setVisible(true);
            }
        });
        jMenu3.add(jMenuItem6);
        jMenu3.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem("Sequence List");
        seqList = new SequenceList(bl, jembossParams);
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                seqList.setVisible(true);
            }
        });
        jMenu3.add(jMenuItem7);
        jMenuBar.add(jMenu3);
        this.favMenu = new JMenu("Favourites");
        jMenuBar.add(this.favMenu);
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic(72);
        JMenuItem jMenuItem8 = new JMenuItem("About Jemboss");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                try {
                    URL uRL = classLoader.getResource("resources/readme.html");
                    new Browser(uRL, "resources/readme.html");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "About Jemboss Guide not found!", "Error", 0);
                }
            }
        });
        jMenu4.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Version");
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                String string = "";
                try {
                    String string2;
                    InputStream inputStream = classLoader.getResourceAsStream("resources/version");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        string = string.concat(string2);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Didn't find resources/version");
                }
                JOptionPane.showMessageDialog(jFrame, string + " by the EMBOSS team");
            }
        });
        jMenu4.add(jMenuItem9);
        jMenuBar.add(jMenu4);
        jMenuBar.add(Box.createHorizontalGlue());
        jFrame.setJMenuBar(jMenuBar);
    }

    public JMenu getFavoriteJMenu() {
        return this.favMenu;
    }

    public void setEnableFileManagers(boolean bl) {
        this.showLocalRemoteFile.setEnabled(bl);
    }

    public void setEnableShowResults(boolean bl) {
        this.fileMenuShowres.setEnabled(bl);
    }

    public static DragTree getLocalDragTree() {
        if (localAndRemoteTree == null) {
            return null;
        }
        return localAndRemoteTree.getLocalDragTree();
    }

    public void deleteTmp(File file, final String string) {
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string2) {
                return string2.endsWith(string);
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(stringArray[i]);
            file2.delete();
        }
    }

    private void writeFavorites() {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossFavorites");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            int n = this.favMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem = this.favMenu.getItem(i);
                if (jMenuItem == null) {
                    printWriter.println();
                    continue;
                }
                printWriter.println(jMenuItem.getText() + "\t" + jMenuItem.getActionCommand());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void exitJemboss() {
        this.writeFavorites();
        String string = new String(System.getProperty("file.separator"));
        String string2 = new String(System.getProperty("user.dir") + string);
        if (this.ao.isSaveUserHomeSelected()) {
            this.ao.userHomeSave();
        }
        if (seqList.isStoreSequenceList()) {
            SetUpMenuBar.saveSequenceList();
        }
        this.deleteTmp(new File(string2), ".jembosstmp");
        System.exit(0);
    }

    public static void saveSequenceList() {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossSeqList");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (int i = 0; i < seqList.getRowCount(); ++i) {
                String string;
                SequenceData sequenceData = seqList.getSequenceData(i);
                String string2 = sequenceData.s_beg;
                if (string2.equals("")) {
                    string2 = "-";
                }
                if ((string = sequenceData.s_end).equals("")) {
                    string = "-";
                }
                if (sequenceData.s_name.equals("")) continue;
                printWriter.println(sequenceData.s_name + " " + string2 + " " + string + " " + sequenceData.s_listFile.toString() + " " + sequenceData.s_default.toString() + " " + sequenceData.s_remote.toString());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        localAndRemoteTree = null;
    }
}

