/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class SequenceSaver {
    public SequenceSaver(Vector vector, File file) {
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(null);
        String string = System.getProperty("user.home");
        JFileChooser jFileChooser = new JFileChooser(string);
        System.setSecurityManager(securityManager);
        if (file == null) {
            file = new File(string + System.getProperty("file.separator") + ((Sequence)vector.get(0)).getName() + ".fasta");
        } else if (!file.getName().endsWith("fasta")) {
            String string2 = file.getName();
            int n = string2.lastIndexOf(".");
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            file = new File(string + System.getProperty("file.separator") + string2 + ".fasta");
        }
        jFileChooser.setSelectedFile(file);
        jFileChooser.addChoosableFileFilter(new SequenceFilter());
        int n = jFileChooser.showSaveDialog(jFileChooser);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.saveFile(file2, vector);
        }
    }

    public SequenceSaver(Vector vector) {
        this(vector, null);
    }

    private void saveFile(File file, Vector vector) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (int i = 0; i < vector.size(); ++i) {
                Sequence sequence = (Sequence)vector.get(i);
                int n = sequence.getLength();
                printWriter.println(">" + sequence.getName());
                String string = sequence.getSequence();
                for (int j = 0; j < n; j += 60) {
                    int n2 = j + 60;
                    if (n2 > n) {
                        n2 = n;
                    }
                    printWriter.println(string.substring(j, n2));
                }
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException saving " + file.getName());
        }
    }
}

