# TOOL bedtools-intersectbed.R: "Intersect BED" (Report overlaps between two feature files such as BED, VCF and GTF. One of the files can also be BAM. Note that when A and B files are compared, the B file is loaded into memory. Therefore to minimize memory usage, one should set the smaller of the two files as the B file. This tool is based on the BEDTools package.)
# INPUT file.a: "Input file A" TYPE GENERIC
# INPUT file.b: "Input file B, the smaller file" TYPE GENERIC
# OUTPUT OPTIONAL intersectbed.bed 
# OUTPUT OPTIONAL intersectbed.bam
# PARAMETER wa: "Write the original entry in A for each overlap" TYPE [yes, no] DEFAULT no (Report the original A feature when an overlap is found. The entire A feature is reported, not just the portion that overlaps with the B feature.)
# PARAMETER u: "Write the original A entry once if any overlaps found in B" TYPE [yes, no] DEFAULT no (Write the original A entry once if any overlaps found in B)
# PARAMETER v: "Only report those entries in A that have no overlaps with B" TYPE [yes, no] DEFAULT no (Only report those entries in A that have no overlaps with B)
# PARAMETER wb: "Write the original entry in B for each overlap" TYPE [yes, no] DEFAULT no (Report the original B feature when an overlap is found. The entire B feature is reported, not just the portion that overlaps with the A feature.)
# PARAMETER s: "Force strandedness" TYPE [yes, no] DEFAULT no (Only report hits in B that overlap A on the same strand. By default, overlaps are reported without respect to strand.)
# PARAMETER abam: "File A is BAM format" TYPE [yes, no] DEFAULT no (Select yes if file A is a BAM file.)
# PARAMETER OPTIONAL wo: "Write the original A and B entries for overlapped A features" TYPE [yes, no] DEFAULT no (Write the original A and B entries plus the number of base pairs of overlap between the two feature. Only A features with overlap are reported.)
# PARAMETER OPTIONAL wao: "Write the original A and B entries for all A features" TYPE [yes, no] DEFAULT no (Write the original A and B entries plus the number of base pairs of overlap between the two features. However, A features w/o overlap are also reported with a NULL B feature and overlap = 0.)
# PARAMETER OPTIONAL c: "For each entry in A, report the number of overlaps with B" TYPE [yes, no] DEFAULT no (For each entry in A, report the number of overlaps with B)
# PARAMETER OPTIONAL f: "Minimum overlap required as a fraction of A" TYPE DECIMAL FROM 0 TO 1 DEFAULT 0.000000001 (Minimum overlap required as a fraction of A. Default is 1E-9 (effectively 1bp\))
# PARAMETER OPTIONAL r: "Require that the fraction overlap be reciprocal for A and B" TYPE [yes, no] DEFAULT no (Require that the fraction overlap be reciprocal for A and B. In other words, if minumum overlap is 0.90 and this option is selected, this requires that B overlap 90% of A and A also overlaps 90% of B.)
# PARAMETER OPTIONAL ubam: "Write uncompressed BAM output" TYPE [yes, no] DEFAULT no (Write uncompressed BAM output. Default is to write compressed BAM.)
# PARAMETER OPTIONAL bed: "When using BAM input, write output as BED" TYPE [yes, no] DEFAULT no (When using BAM input, the default is to write output in BAM.)
# PARAMETER OPTIONAL split: "Treat split BAM or BED12 entries as distinct BED intervals" TYPE [yes, no] DEFAULT no (Treat "split" BAM (i.e., having an N CIGAR operation\) or BED12 entries as distinct BED intervals.)

# AMS 23.4.2012
# AMS 11.10.2012 Fixed BAM file support

# binary
binary <- c(file.path(chipster.tools.path, "bedtools", "bin", "intersectBed"))

# options
outfile <- "intersectbed.bed"
options <- paste("")
if (abam == "yes") {
	outfile <- "intersectbed.bam"
	if (ubam == "yes") {
		options <- paste(options, "-ubam")
	}
	if (bed == "yes") {
		options <- paste(options, "-bed")
		outfile <- "intersectbed.bed"
	}
}
if (wa == "yes") {options <- paste(options,"-wa")}
if (wb == "yes") {options <- paste(options,"-wb")}
if (wo == "yes") {options <- paste(options,"-wo")}
if (wao == "yes") {options <- paste(options,"-wao")}
if (u == "yes") {options <- paste(options, "-u")}
if (c == "yes") {options <- paste(options, "-c")}
if (v == "yes") {options <- paste(options, "-v")}
options <- paste(options, "-f", f)
if (r == "yes") {options <- paste(options, "-r")}
if (s == "yes") {options <- paste(options, "-s")}
if (split == "yes") {options <- paste(options, "-split")}

# input files
if (abam == "yes") {options <- paste(options, "-abam file.a -b file.b")}
if (abam == "no") {options <- paste(options, "-a file.a -b file.b")}

# command
command <- paste(binary, options, ">", outfile)

#stop(paste('CHIPSTER-NOTE: ', command))

# run
system(command)

if (file.exists("intersectbed.bed")){
	if (file.info("intersectbed.bed")$size == 0) {
		system("echo \"# No results found\" > intersectbed.bed")
	}	
}