/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.gzip.AbstractCompressedStream;
import org.eclipse.jetty.http.gzip.CompressedResponseWrapper;
import org.eclipse.jetty.io.UncheckedPrintWriter;
import org.eclipse.jetty.servlets.GzipFilter;

public class IncludableGzipFilter
extends GzipFilter {
    boolean _uncheckedPrintWriter = false;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String tmp = filterConfig.getInitParameter("uncheckedPrintWriter");
        if (tmp != null) {
            this._uncheckedPrintWriter = Boolean.valueOf(tmp);
        }
    }

    @Override
    protected CompressedResponseWrapper createWrappedResponse(HttpServletRequest request, HttpServletResponse response, final String compressionType) {
        IncludableResponseWrapper wrappedResponse = null;
        if (compressionType.equals("gzip")) {
            wrappedResponse = new IncludableResponseWrapper(request, response){

                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minCompressSize) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, response, contentLength, bufferSize, minCompressSize){

                        protected DeflaterOutputStream createStream() throws IOException {
                            return new GZIPOutputStream((OutputStream)this._response.getOutputStream(), this._bufferSize);
                        }

                        protected void setHeader(String name, String value) {
                            super.setHeader(name, value);
                            HttpServletResponse response = (HttpServletResponse)this.getResponse();
                            if (!response.containsHeader(name)) {
                                response.setHeader("org.eclipse.jetty.server.include." + name, value);
                            }
                        }
                    };
                }
            };
        } else if (compressionType.equals("deflate")) {
            wrappedResponse = new IncludableResponseWrapper(request, response){

                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minCompressSize) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, response, contentLength, bufferSize, minCompressSize){

                        protected DeflaterOutputStream createStream() throws IOException {
                            return new DeflaterOutputStream((OutputStream)this._response.getOutputStream(), new Deflater(IncludableGzipFilter.this._deflateCompressionLevel, IncludableGzipFilter.this._deflateNoWrap));
                        }

                        protected void setHeader(String name, String value) {
                            super.setHeader(name, value);
                            HttpServletResponse response = (HttpServletResponse)this.getResponse();
                            if (!response.containsHeader(name)) {
                                response.setHeader("org.eclipse.jetty.server.include." + name, value);
                            }
                        }
                    };
                }
            };
        } else {
            throw new IllegalStateException(compressionType + " not supported");
        }
        this.configureWrappedResponse(wrappedResponse);
        return wrappedResponse;
    }

    private abstract class IncludableResponseWrapper
    extends CompressedResponseWrapper {
        public IncludableResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(request, response);
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            if (!response.containsHeader(name)) {
                response.setHeader("org.eclipse.jetty.server.include." + name, value);
            }
        }

        protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
            if (IncludableGzipFilter.this._uncheckedPrintWriter) {
                return encoding == null ? new UncheckedPrintWriter(out) : new UncheckedPrintWriter((Writer)new OutputStreamWriter(out, encoding));
            }
            return super.newWriter(out, encoding);
        }
    }
}

