/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.handlers;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.DataBeanHandler;
import java.util.HashSet;
import java.util.Set;

public abstract class DataBeanHandlerBase
implements DataBeanHandler {
    protected Set<DataBean.StorageMethod> supportedDataBeanTypes;
    protected DataManager dataManager;

    protected DataBeanHandlerBase(DataManager dataManager, DataBean.StorageMethod ... supportedTypes) {
        this.dataManager = dataManager;
        this.supportedDataBeanTypes = new HashSet<DataBean.StorageMethod>();
        for (DataBean.StorageMethod type : supportedTypes) {
            this.supportedDataBeanTypes.add(type);
        }
    }

    protected void checkCompatibility(DataBean dataBean) {
        if (dataBean == null) {
            throw new IllegalArgumentException("DataBean is null.");
        }
        if (!this.supportedDataBeanTypes.contains((Object)dataBean.getStorageMethod())) {
            throw new IllegalArgumentException("Unsupported DataBean type: " + (Object)((Object)dataBean.getStorageMethod()));
        }
    }
}

