/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FSDataEventTest
implements DataChangeListener {
    DataChangeEvent lastEvent = null;
    boolean gotTwice = false;

    @BeforeTest
    public void init() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
    }

    @Test(groups={"unit"})
    public void testEvents() throws IOException, MicroarrayException {
        DataManager manager = new DataManager();
        manager.addDataChangeListener(this);
        manager.setEventsEnabled(true);
        DataBean bean1 = manager.createDataBean("My bean.txt");
        this.assertNoEvent();
        DataBean bean2 = manager.createDataBean("My other bean.txt");
        this.assertNoEvent();
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        this.assertNoEvent();
        manager.getRootFolder().addChild(bean1);
        this.assertDataCreatedEvent();
        manager.getRootFolder().addChild(bean2);
        this.assertDataCreatedEvent();
        bean1.addLink(DataBean.Link.ANNOTATION, bean2);
        this.assertLinksChangedEvent();
        bean1.setName("My nice bean.txt");
        this.assertContentChangedEvent();
        manager.getRootFolder().removeChild(bean2);
        this.assertDataRemovedEvent();
    }

    private void assertDataRemovedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((boolean)(this.lastEvent instanceof DataItemRemovedEvent), (String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()));
        this.lastEvent = null;
    }

    private void assertContentChangedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((boolean)(this.lastEvent instanceof ContentChangedEvent), (String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()));
        this.lastEvent = null;
    }

    private void assertLinksChangedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((boolean)(this.lastEvent instanceof LinksChangedEvent), (String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()));
        this.lastEvent = null;
    }

    private void assertDataCreatedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((boolean)(this.lastEvent instanceof DataItemCreatedEvent), (String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()));
        this.lastEvent = null;
    }

    private void assertNoEvent() {
        Assert.assertNull((Object)this.lastEvent);
    }

    @Override
    public void dataChanged(DataChangeEvent event) {
        if (this.lastEvent != null) {
            this.gotTwice = true;
        } else {
            this.lastEvent = event;
        }
    }
}

