/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.util.LookaheadStringReader;
import java.util.LinkedList;

public class RequestExecuter {
    private DataManager manager;

    public RequestExecuter(DataManager manager) {
        this.manager = manager;
    }

    public Feature execute(String request, DataBean data) {
        if (request.startsWith("/")) {
            return this.executeFeature(request, data);
        }
        return this.executeModifier(request, data);
    }

    private Feature executeModifier(String request, DataBean data) {
        LookaheadStringReader requestReader = new LookaheadStringReader(request);
        String modifierName = requestReader.readTo("(");
        Modifier modifier = this.manager.fetchModifier(modifierName);
        requestReader.read();
        String modifiedExpression = requestReader.readToLast(")");
        Feature feature = this.execute(modifiedExpression, data);
        LinkedList<Feature> fl = new LinkedList<Feature>();
        fl.add(feature);
        modifier.setInputs(fl);
        requestReader.read();
        if (!requestReader.isAtEnd()) {
            throw new IllegalArgumentException("malformed request: " + request);
        }
        return modifier.getOutput();
    }

    private Feature executeFeature(String request, DataBean data) {
        return this.manager.fetchFeature(request, data);
    }
}

