/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.DataModel;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorGroupsPanel
extends JPanel {
    DataModel dataModel;
    Float[] scaleValues;

    public ColorGroupsPanel(DataModel dataModel, List<String> colorGroupList) {
        this.dataModel = dataModel;
        this.scaleValues = dataModel.getColorValues();
        this.setBackground(Color.black);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        for (String groupStr : colorGroupList) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics2D g = (Graphics2D)((Image)image).getGraphics();
            Color color = dataModel.getColorModel().getColorFor(dataModel.convertToScaled(dataModel.getColorScaleValues(), colorGroupList.indexOf(groupStr)));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            DataPoint.paintBall(2, 2, 12, 12, color, g);
            ImageIcon icon = new ImageIcon(image);
            JLabel label = new JLabel(groupStr, icon, 2);
            label.setOpaque(false);
            label.setForeground(Color.white);
            this.add((Component)label, c);
            ++c.gridy;
        }
    }
}

