/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CnaFlagTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CytobandTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.EmptyTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PeakTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadSummaryTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScatterplotTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.LinkedList;

public class TrackFactory {
    public static TrackGroup getGeneTrackGroup(GBrowserPlot genomePlot, AreaRequestHandler annotationDataSource, AreaRequestHandler repeatDataSource, boolean isUserData) throws FileNotFoundException {
        GBrowserView dataView = genomePlot.getDataView();
        GeneTrackGroup geneGroup = new GeneTrackGroup(dataView, annotationDataSource, repeatDataSource, isUserData);
        return geneGroup;
    }

    public static TrackGroup getThinSeparatorTrackGroup(GBrowserPlot genomePlot) {
        GBrowserView view = genomePlot.getDataView();
        TrackGroup group = new TrackGroup(view);
        SeparatorTrack separator = new SeparatorTrack(Color.LIGHT_GRAY, 3, 0L, Long.MAX_VALUE);
        separator.setView(view);
        group.addTrack(separator);
        return group;
    }

    public static TrackGroup getThickSeparatorTrackGroup(GBrowserPlot genomePlot) {
        GBrowserView view = genomePlot.getDataView();
        TrackGroup group = new TrackGroup(view);
        SeparatorTrack3D separator1 = new SeparatorTrack3D(0L, Long.MAX_VALUE, false);
        separator1.setView(view);
        group.addTrack(separator1);
        EmptyTrack empty = new EmptyTrack(2);
        empty.setView(view);
        group.addTrack(empty);
        SeparatorTrack3D separator2 = new SeparatorTrack3D(0L, Long.MAX_VALUE, true);
        separator2.setView(view);
        group.addTrack(separator2);
        return group;
    }

    public static TrackGroup getReadTrackGroup(GBrowserPlot genomePlot, AreaRequestHandler userData, AreaRequestHandler seqFile, String title) throws FileNotFoundException, MalformedURLException {
        GBrowserView dataView = genomePlot.getDataView();
        ReadTrackGroup readGroup = new ReadTrackGroup(dataView, userData, seqFile, title);
        readGroup.initialise();
        return readGroup;
    }

    public static TrackGroup getReadSummaryTrackGroup(GBrowserPlot genomePlot, AreaRequestHandler userData, AreaRequestHandler seqFile, String title, AreaRequestHandler summaryDataSource) throws FileNotFoundException, MalformedURLException {
        GBrowserView dataView = genomePlot.getDataView();
        ReadSummaryTrackGroup readGroup = new ReadSummaryTrackGroup(dataView, userData, seqFile, title, summaryDataSource);
        readGroup.initialise();
        return readGroup;
    }

    public static TrackGroup getPeakTrackGroup(GBrowserPlot plot, AreaRequestHandler areaRequestHandler) {
        GBrowserView dataView = plot.getDataView();
        PeakTrack annotation = new PeakTrack(GBrowserConstants.BED_COLOR, 0L, Long.MAX_VALUE);
        annotation.setView(dataView);
        annotation.setAreaRequestHandler(areaRequestHandler);
        return new TrackGroup(annotation);
    }

    public static TrackGroup getCytobandTrackGroup(GBrowserPlot plot, AreaRequestHandler cytobandData) {
        CytobandTrack overviewCytobands = new CytobandTrack(false);
        overviewCytobands.setView(plot.getOverviewView());
        overviewCytobands.setAreaRequestHandler(cytobandData);
        return new TrackGroup(overviewCytobands);
    }

    public static TitleTrack getTitleTrack(GBrowserPlot genomePlot, String title) {
        GBrowserView dataView = genomePlot.getDataView();
        TitleTrack titleTrack = new TitleTrack(title, Color.black);
        titleTrack.setView(dataView);
        return titleTrack;
    }

    public static TrackGroup getCnaTrackGroup(GBrowserPlot plot, CnaConversion conversion, LinkedList<String> sampleNames, boolean showFrequencies, boolean showCalls, boolean showLogratios) {
        GBrowserView view = plot.getDataView();
        TrackGroup group = new TrackGroup(view);
        if (showFrequencies) {
            TitleTrack title2 = new TitleTrack("loss frequency", Color.black, GBrowserConstants.SCATTERPLOT_TITLE_COLOR);
            title2.setView(view);
            group.addTrack(title2);
            ScatterplotTrack lossFreq = new ScatterplotTrack(GBrowserConstants.BED_COLOR, 100, 0.0f, 1.0f, ColumnType.LOSS, 0L, Long.MAX_VALUE);
            lossFreq.setView(view);
            lossFreq.setAreaRequestHandler(conversion);
            group.addTrack(lossFreq);
            TitleTrack title3 = new TitleTrack("gain frequency", Color.black, GBrowserConstants.SCATTERPLOT_TITLE_COLOR);
            title3.setView(view);
            group.addTrack(title3);
            ScatterplotTrack gainFreq = new ScatterplotTrack(GBrowserConstants.BED_COLOR, 100, 0.0f, 1.0f, ColumnType.GAIN, 0L, Long.MAX_VALUE);
            gainFreq.setView(view);
            gainFreq.setAreaRequestHandler(conversion);
            group.addTrack(gainFreq);
        }
        for (int i = 0; i < sampleNames.size(); ++i) {
            TitleTrack title;
            String name = sampleNames.get(i);
            if (showCalls) {
                title = new TitleTrack(name, Color.black);
                title.setView(view);
                group.addTrack(title);
                CnaFlagTrack flag = new CnaFlagTrack(GBrowserConstants.BED_COLOR, i, Color.RED, 0L, Long.MAX_VALUE);
                flag.setView(view);
                flag.setAreaRequestHandler(conversion);
                group.addTrack(flag);
                SeparatorTrack separator1 = new SeparatorTrack(Color.gray, 1, 0L, Long.MAX_VALUE);
                separator1.setView(view);
                group.addTrack(separator1);
            }
            if (!showLogratios) continue;
            title = new TitleTrack(name, Color.black, GBrowserConstants.SCATTERPLOT_TITLE_COLOR);
            title.setView(view);
            group.addTrack(title);
            ScatterplotTrack logRatio = new ScatterplotTrack(GBrowserConstants.BED_COLOR, 24, -1.0f, 1.0f, i, 0, Long.MAX_VALUE);
            logRatio.setView(view);
            logRatio.setAreaRequestHandler(conversion);
            group.addTrack(logRatio);
        }
        return group;
    }
}

