/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageEstimateTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GelTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSequenceTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;

public class ReadTrackGroup
extends TrackGroup {
    private final Color histogramColor = new Color(100, 100, 100);
    private final Color fontColor = Color.black;
    protected TitleTrack titleTrack;
    protected CoverageEstimateTrack readOverview;
    protected ReadPileTrack reads;
    protected ReferenceSequenceTrack seq;
    protected CoverageEstimateTrack readOverviewReversed;
    protected ReadPileTrack readsReversed;
    protected CoverageTrack profileTrack;
    protected CoverageTrack profileSNPTrack;
    protected GelTrack gelTrack;
    protected SeparatorTrack sepTrackReads;
    protected SeparatorTrack sepTrackSeq;
    protected SeparatorTrack sepTrackProfile;
    protected SeparatorTrack sepTrackProfileSNP;
    protected SeparatorTrack sepTrackQualityCoverage;
    protected SeparatorTrack sepTrackGel;
    private AreaRequestHandler seqFile;
    private AreaRequestHandler userData;
    private ReadpartDataProvider readpartProvider;
    private String title;
    private boolean initialised = false;
    private SeparatorTrack sepTrackReadOverview;

    public ReadTrackGroup(GBrowserView view, AreaRequestHandler userData, AreaRequestHandler seqFile, String title) {
        super(view);
        this.userData = userData;
        this.seqFile = seqFile;
        this.title = title;
        if (userData != null) {
            this.readpartProvider = new ReadpartDataProvider(view, userData);
        }
    }

    public void initialise() {
        this.titleTrack = new TitleTrack(this.title, Color.black);
        this.tracks.add(this.titleTrack);
        if (this.userData != null) {
            this.addReadOverviewTrack();
            this.sepTrackReadOverview = new SeparatorTrack(Color.gray, 1, GBrowserConstants.SWITCH_VIEWS_AT, Long.MAX_VALUE);
            this.sepTrackReadOverview.setView(this.view);
            this.tracks.add(this.sepTrackReadOverview);
            this.reads = new ReadPileTrack(this.readpartProvider, this.seqFile, this.fontColor, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.reads.setView(this.view);
            this.reads.setAreaRequestHandler(this.userData);
            this.tracks.add(this.reads);
            this.sepTrackReads = new SeparatorTrack(Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.sepTrackReads.setView(this.view);
            this.sepTrackReads.setName("Reads");
            this.tracks.add(this.sepTrackReads);
        }
        if (this.seqFile != null) {
            this.seq = new ReferenceSequenceTrack(GBrowserConstants.SHOW_REFERENCE_AT);
            this.seq.setView(this.view);
            this.seq.setAreaRequestHandler(this.seqFile);
            this.tracks.add(this.seq);
            this.sepTrackSeq = new SeparatorTrack(Color.gray, 1, 0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.sepTrackSeq.setView(this.view);
            this.sepTrackSeq.setName("Reads");
            this.tracks.add(this.sepTrackSeq);
        }
        if (this.userData != null) {
            this.addReadOverviewReversedTrack();
            this.readsReversed = new ReadPileTrack(this.readpartProvider, this.seqFile, this.fontColor, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.readsReversed.setView(this.view);
            this.readsReversed.setAreaRequestHandler(this.userData);
            this.readsReversed.setStrand(Strand.REVERSE);
            this.tracks.add(this.readsReversed);
            SeparatorTrack sepTrackReads2 = new SeparatorTrack(Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            sepTrackReads2.setView(this.view);
            sepTrackReads2.setName("Reads");
            this.tracks.add(sepTrackReads2);
            Color forwardColor = new Color(0, 0, 0, 64);
            Color reverseColor = new Color(GBrowserConstants.COLOR_BLUE.getRed(), GBrowserConstants.COLOR_BLUE.getGreen(), GBrowserConstants.COLOR_BLUE.getBlue(), 64);
            Color totalColor = Color.gray;
            this.profileTrack = new CoverageTrack(this.readpartProvider, this.seqFile, forwardColor, reverseColor, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.profileTrack.setView(this.view);
            this.profileTrack.setAreaRequestHandler(this.userData);
            this.profileTrack.setName("ProfileTrack");
            this.tracks.add(this.profileTrack);
            this.sepTrackProfile = new SeparatorTrack(Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.sepTrackProfile.setView(this.view);
            this.sepTrackProfile.setName("ProfileTrack");
            this.tracks.add(this.sepTrackProfile);
            this.profileSNPTrack = new CoverageTrack(this.readpartProvider, this.seqFile, totalColor, null, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.profileSNPTrack.setView(this.view);
            this.profileSNPTrack.setAreaRequestHandler(this.userData);
            this.profileSNPTrack.setName("ProfileSNPTrack");
            this.tracks.add(this.profileSNPTrack);
            this.sepTrackProfileSNP = new SeparatorTrack(Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.sepTrackProfileSNP.setView(this.view);
            this.sepTrackProfileSNP.setName("ProfileSNPTrack");
            this.tracks.add(this.sepTrackProfileSNP);
            this.gelTrack = new GelTrack(this.readpartProvider, Color.WHITE, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.gelTrack.setView(this.view);
            this.gelTrack.setAreaRequestHandler(this.userData);
            this.gelTrack.setStrand(Strand.BOTH);
            this.tracks.add(this.gelTrack);
        }
        this.initialised = true;
    }

    protected void addReadOverviewReversedTrack() {
        this.readOverviewReversed = new CoverageEstimateTrack(this.histogramColor, GBrowserConstants.SWITCH_VIEWS_AT, false, true);
        this.readOverviewReversed.setView(this.view);
        this.readOverviewReversed.setAreaRequestHandler(this.userData);
        this.readOverviewReversed.setStrand(Strand.REVERSE);
        this.readOverviewReversed.setName("ReadOverview");
        this.tracks.add(this.readOverviewReversed);
    }

    protected void addReadOverviewTrack() {
        this.readOverview = new CoverageEstimateTrack(this.histogramColor, GBrowserConstants.SWITCH_VIEWS_AT, false, true);
        this.readOverview.setView(this.view);
        this.readOverview.setAreaRequestHandler(this.userData);
        this.readOverview.setName("ReadOverview");
        this.tracks.add(this.readOverview);
    }

    public void setVisibleSNP(boolean b) {
        this.check();
        if (b) {
            this.reads.enableSNPHighlight();
            this.readsReversed.enableSNPHighlight();
            this.profileSNPTrack.enableSNPHighlight();
        } else {
            this.reads.disableSNPHiglight();
            this.readsReversed.disableSNPHiglight();
            this.profileSNPTrack.disableSNPHighlight();
        }
        this.view.fireAreaRequests();
        this.view.redraw();
    }

    @Override
    public String getName() {
        this.check();
        return "Read Track Group";
    }

    @Override
    public void showOrHide(String name, boolean state) {
        this.check();
        super.showOrHide(name, state);
        if (name.equals("highlightSNP")) {
            this.setVisibleSNP(state);
        }
    }

    private void check() {
        if (!this.initialised) {
            throw new IllegalStateException("you must call initialise() after creating this object");
        }
    }
}

