/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.CnaRow;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class CnaFlagTrack
extends Track {
    private static final int MIN_VISIBLE_SIZE = 5;
    private static final int SYMBOL_HEIGHT = 10;
    private TreeMap<IndexKey, CnaRow> rows = new TreeMap();
    private long maxBpLength;
    private long minBpLength;
    private Color gainColor = GBrowserConstants.COLOR_RED;
    private Color lossColor = GBrowserConstants.COLOR_BLUE;
    private int sampleIndex;

    public CnaFlagTrack(Color gainColor, int sampleIndex, Color lossColor, long minBpLength, long maxBpLength) {
        this.sampleIndex = sampleIndex;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.rows != null) {
            Iterator<IndexKey> iter = this.rows.keySet().iterator();
            while (iter.hasNext()) {
                CnaRow row = this.rows.get(iter.next());
                if (!row.getRegion().intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                int y = 0;
                CnaRow.Sample sample = row.getSamples().get(this.sampleIndex);
                Color color = Color.lightGray;
                if (sample.getFlag() == null) continue;
                if (sample.getFlag().floatValue() < 0.0f) {
                    color = this.gainColor;
                } else if (sample.getFlag().floatValue() > 0.0f) {
                    color = this.lossColor;
                }
                int alpha = 255 - (int)Math.min(1.0, (double)Math.abs(sample.getFlag().floatValue()) * 255.0);
                Color aColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
                this.createDrawable(row.getRegion().start, row.getRegion().end, y, 10, aColor, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int y, int height, Color c, Collection<Drawable> drawables) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        if (rect.width < 5) {
            rect.width = 5;
        }
        rect.y = y;
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, c));
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent region : areaResult.getContents()) {
            this.rows.put((IndexKey)region.values.get((Object)ColumnType.ID), (CnaRow)region.values.get((Object)ColumnType.VALUE));
        }
        this.getView().redraw();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public int getMinHeight() {
        return 10;
    }
}

