/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import org.jfree.chart.ChartPanel;

public class GBrowserChartPanel
extends ChartPanel {
    private GBrowserPlot plot;
    private Map<ScrollGroup, ScrollGroupBar> scrollBarsMap = new HashMap<ScrollGroup, ScrollGroupBar>();
    private List<ScrollGroupBar> scrollBarsList = new LinkedList<ScrollGroupBar>();
    private int maxY;

    public GBrowserChartPanel() {
        super(null);
    }

    public void paintComponent(Graphics g) {
        int height = this.getParent().getSize().height;
        Dimension size = new Dimension(this.getParent().getSize().width, height);
        this.setPreferredSize(size);
        this.setSize(size);
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        this.setMinimumDrawWidth((int)((RectangularShape)available).getWidth() - 1);
        this.setMinimumDrawHeight((int)((RectangularShape)available).getHeight() - 1);
        this.setMaximumDrawWidth((int)((RectangularShape)available).getWidth() + 1);
        this.setMaximumDrawHeight((int)((RectangularShape)available).getHeight() + 1);
        this.udpateScrollBars();
        super.paintComponent(g);
    }

    private void udpateScrollBars() {
        this.removeAll();
        int maxY = this.getHeight() - this.getInsets().bottom;
        int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        int scrollBarX = this.getWidth() - this.getInsets().right - scrollBarWidth;
        int y = this.getInsets().top;
        for (JScrollBar jScrollBar : this.scrollBarsList) {
            if (jScrollBar == null) continue;
            int height = Math.min(maxY, jScrollBar.getHeight());
            jScrollBar.setBounds(scrollBarX, y, scrollBarWidth, height);
            y += height;
            this.add(jScrollBar);
        }
    }

    public void setPlot(GBrowserPlot plot) {
        this.plot = plot;
    }

    public void setScrollGroupOrder(Collection<ScrollGroup> scrollGroups, int maxY) {
        this.maxY = maxY;
        Iterator<ScrollGroup> iter = this.scrollBarsMap.keySet().iterator();
        while (iter.hasNext()) {
            ScrollGroup mapGroup = iter.next();
            if (scrollGroups.contains(mapGroup)) continue;
            iter.remove();
        }
        this.scrollBarsList.clear();
        for (ScrollGroup group : scrollGroups) {
            ScrollGroupBar bar;
            if (!this.scrollBarsMap.containsKey(group)) {
                bar = new ScrollGroupBar();
                this.scrollBarsMap.put(group, bar);
            } else {
                bar = this.scrollBarsMap.get(group);
            }
            this.scrollBarsList.add(bar);
        }
    }

    public void setScrollGroupBoundaries(ScrollGroup group) {
        int barHeight;
        int extent = barHeight = group.getHeight();
        int maximum = group.isScrollEnabled() ? group.getFullHeight() : group.getHeight();
        ScrollGroupBar bar = this.scrollBarsMap.get(group);
        if (bar != null) {
            boolean visible = group.isVisible() && group.isScrollEnabled() && maximum > barHeight;
            int referenceY = group.getScrollReferenceY();
            bar.set(maximum, extent, referenceY);
            bar.setHeight(barHeight);
            bar.setVisible(visible);
            this.validate();
        }
    }

    public int getScrollValue(ScrollGroup scrollGroup) {
        ScrollGroupBar bar;
        if (this.scrollBarsMap.containsKey(scrollGroup) && (bar = this.scrollBarsMap.get(scrollGroup)).isVisible()) {
            return bar.getValue();
        }
        return 0;
    }

    public void clean() {
        this.scrollBarsMap.clear();
    }

    public class ScrollGroupBar
    extends JScrollBar
    implements AdjustmentListener {
        private int referenceY = 0;

        public ScrollGroupBar() {
            this.addAdjustmentListener(this);
            this.setUnitIncrement(10);
        }

        public void setHeight(int height) {
            int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            this.setSize(scrollBarWidth, height);
        }

        public void set(int maximum, int extent, int referenceY) {
            int referenceDelta = referenceY - this.referenceY;
            this.referenceY = referenceY;
            this.setMaximum(maximum);
            this.getModel().setExtent(extent);
            this.setValue(this.getValue() + referenceDelta);
        }

        public void setDefaultValue() {
            this.setValue(this.referenceY - this.getModel().getExtent() / 2);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            GBrowserChartPanel.this.plot.redraw();
        }
    }
}

