/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GeneSearchHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GeneSearchFileFetcherThread
extends Thread {
    private BlockingQueue<BpCoordFileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue;
    private GeneSearchHandler areaRequestThread;
    private LineDataSource dataSource;
    private HashMap<String, Chromosome> geneNameMap;
    private boolean poison = false;

    public GeneSearchFileFetcherThread(BlockingQueue<BpCoordFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue, GeneSearchHandler geneSearchHandler, LineDataSource data) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = geneSearchHandler;
        this.dataSource = data;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setName(this.getClass().getName());
        while (!this.poison) {
            try {
                for (BpCoordFileRequest fileRequest : this.fileRequestQueue) {
                    if (!fileRequest.getStatus().poison) continue;
                    this.poison = true;
                    return;
                }
                this.processFileRequest(this.fileRequestQueue.take());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void readFile() throws IOException {
        String line;
        while ((line = this.dataSource.readLine()) != null) {
            String[] cols = line.split("\t");
            if (cols.length != 2) continue;
            String chr = cols[0];
            String geneName = cols[1];
            this.geneNameMap.put(geneName.toLowerCase(), new Chromosome(chr));
        }
    }

    private void processFileRequest(BpCoordFileRequest fileRequest) throws IOException {
        if (fileRequest.getStatus().poison) {
            this.poison = true;
            return;
        }
        if (this.geneNameMap == null) {
            this.geneNameMap = new HashMap();
            this.readFile();
        }
        List<RegionContent> resultList = this.processGeneSearch((GeneRequest)fileRequest.areaRequest, fileRequest);
        ParsedFileResult result = new ParsedFileResult(resultList, fileRequest, fileRequest.areaRequest, fileRequest.getStatus());
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }

    private List<RegionContent> processGeneSearch(GeneRequest areaRequest, BpCoordFileRequest fileRequest) throws IOException {
        String searchString = areaRequest.getSearchString();
        Chromosome chr = this.geneNameMap.get(searchString.toLowerCase());
        LinkedList<RegionContent> resultList = new LinkedList<RegionContent>();
        if (chr != null) {
            resultList.add(new RegionContent(new Region(null, null, chr), null));
        }
        return resultList;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

