/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BedTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TabixFileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.broad.tribble.readers.TabixReader;

public class BedTabixFileFetcherThread
extends TabixFileFetcherThread {
    private BedTabixHandlerThread areaRequestThread;

    public BedTabixFileFetcherThread(BlockingQueue<BpCoordFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue, BedTabixHandlerThread areaRequestThread, TabixDataSource dataSource) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.dataSource = dataSource;
        this.setDaemon(true);
    }

    @Override
    protected void processFileRequest(BpCoordFileRequest fileRequest) throws IOException {
        if (fileRequest.getStatus().poison) {
            this.poison = true;
            return;
        }
        LinkedList<RegionContent> resultList = new LinkedList<RegionContent>();
        Region region = new Region(fileRequest.getFrom(), fileRequest.getTo());
        TabixReader.Iterator iter = this.getTabixIterator(region);
        if (iter != null) {
            String line;
            while ((line = iter.next()) != null) {
                resultList.add(new RegionContent(this.parseBedLine(line)));
            }
        }
        ParsedFileResult result = new ParsedFileResult(resultList, fileRequest, fileRequest.areaRequest, fileRequest.getStatus());
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }

    private Region parseBedLine(String line) {
        String[] cols = line.split("\t");
        String chr = cols[0];
        String start = cols[1];
        String end = cols[2];
        return new Region(Long.parseLong(start), Long.parseLong(end), new Chromosome(chr));
    }
}

