/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BedTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.CytobandHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GeneSearchHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GtfTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.IndexedFastaHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TabixSummaryHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.CytobandDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.IndexedFastaDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.SAMDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixSummaryDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.ChromosomeBinarySearch;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.CnaLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.LineToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.VcfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackFactory;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import fi.csc.microarray.util.BrowserLauncher;
import fi.csc.microarray.util.IOUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class GBrowser
implements ComponentListener {
    static final String WAITPANEL = "waitpanel";
    static final String PLOTPANEL = "plotpanel";
    private List<TrackDefinition> tracks = new LinkedList<TrackDefinition>();
    private GBrowserPlot plot;
    private JPanel plotPanel = new JPanel(new CardLayout());
    private AnnotationManager annotationManager;
    private GeneIndexActions gia;
    private ViewLimiter viewLimiter;
    protected boolean geneSearchDone;
    private GBrowserSettings settings;
    private List<Interpretation> interpretations;

    public void initialise() throws Exception {
        this.annotationManager = new AnnotationManager(this);
        this.annotationManager.initialize();
        this.settings = new GBrowserSettings();
        this.settings.initialise(this);
    }

    private void createAvailableTracks() {
        this.tracks.add(new TrackDefinition(AnnotationManager.AnnotationType.GTF_TABIX.getId(), new Interpretation(TrackType.GENES, null)));
        this.tracks.add(new TrackDefinition(AnnotationManager.AnnotationType.CYTOBANDS.getId(), new Interpretation(TrackType.CYTOBANDS, null)));
        for (int i = 0; i < this.interpretations.size(); ++i) {
            Interpretation interpretation = this.interpretations.get(i);
            this.tracks.add(new TrackDefinition(interpretation.getName(), interpretation));
        }
        this.settings.updateDatasetSwitches();
    }

    public void setFullHeight(boolean fullHeight) {
        this.plot.setFullLayoutMode(fullHeight);
    }

    public JComponent getVisualisation(List<Interpretation> interpretations) throws IOException {
        this.interpretations = interpretations;
        this.settings.updateInterpretations();
        this.tracks.clear();
        this.createAvailableTracks();
        JPanel waitPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        waitPanel.add((Component)new JLabel("<html><p style=\"font-size: larger\">Please select genome and click " + this.settings.getGoButtonText() + "</p></html>"), c);
        this.plotPanel.add((Component)waitPanel, WAITPANEL);
        return this.plotPanel;
    }

    public void updateCoverageScale() {
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    private AnnotationManager.Genome getGenome() {
        return this.settings.getGenome();
    }

    public void updateTracks() {
        this.plot.getOverviewView().clean();
        this.plot.getDataView().clean();
        this.plot.chartPanel.clean();
        AnnotationManager.Genome genome = this.getGenome();
        ScrollGroup overview = new ScrollGroup("Overview");
        AnnotationScrollGroup annotations = new AnnotationScrollGroup();
        SeparatorTrack3D separator = new SeparatorTrack3D(0L, Long.MAX_VALUE, true);
        separator.setView(this.plot.getDataView());
        this.plot.getDataView().addTrackGroup(new TrackGroup(separator));
        block42: for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            switch (track.interpretation.type) {
                case CYTOBANDS: {
                    URL cytobandUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.CYTOBANDS);
                    try {
                        if (cytobandUrl == null) continue block42;
                        CytobandDataSource cytobandDataSource = new CytobandDataSource(cytobandUrl);
                        CytobandHandlerThread cytobandRequestHandler = new CytobandHandlerThread(cytobandDataSource);
                        overview.addTrackGroup(TrackFactory.getCytobandTrackGroup(this.plot, cytobandRequestHandler));
                        this.viewLimiter = new ViewLimiter(this.plot.getOverviewView().getQueueManager(), cytobandRequestHandler, this.plot.getOverviewView());
                        this.plot.getDataView().setViewLimiter(this.viewLimiter);
                        this.plot.getOverviewView().setViewLimiter(this.viewLimiter);
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case GENES: {
                    URL gtfUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX);
                    URL gtfIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX);
                    URL repeatUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT);
                    URL repeatIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT_INDEX);
                    GtfTabixHandlerThread gtfRequestHandler = null;
                    BedTabixHandlerThread repeatRequestHandler = null;
                    try {
                        if (gtfUrl != null && gtfIndexUrl != null) {
                            TabixDataSource gtfDataSource = new TabixDataSource(gtfUrl, gtfIndexUrl);
                            gtfRequestHandler = new GtfTabixHandlerThread(gtfDataSource);
                            URL geneUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GENE_CHRS).getUrl();
                            LineDataSource geneDataSource = new LineDataSource(geneUrl, GeneSearchHandler.class);
                            GeneSearchHandler geneRequestHandler = new GeneSearchHandler(geneDataSource);
                            this.gia = new GeneIndexActions(this.plot.getDataView().getQueueManager(), gtfRequestHandler, geneRequestHandler);
                        }
                        if (repeatUrl != null && repeatIndexUrl != null) {
                            TabixDataSource repeatDataSource = new TabixDataSource(repeatUrl, repeatIndexUrl);
                            repeatRequestHandler = new BedTabixHandlerThread(repeatDataSource);
                        }
                        TrackGroup geneGroup = TrackFactory.getGeneTrackGroup(this.plot, gtfRequestHandler, repeatRequestHandler, false);
                        track.setTrackGroup(geneGroup);
                        annotations.addTrackGroup(geneGroup);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    catch (IOException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case REFERENCE: {
                    break;
                }
                case TRANSCRIPTS: {
                    break;
                }
            }
        }
        this.plot.getOverviewView().addScrollGroup(overview);
        this.plot.getDataView().addScrollGroup(annotations);
        this.plot.getDataView().addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup samples = new ScrollGroup("Samples", true);
        boolean firstReadTrack = true;
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            try {
                SAMHandlerThread treatmentRequestHandler;
                DataSource treatmentData;
                DataUrl dataUrl = track.interpretation.primaryData;
                if (track.interpretation.type != TrackType.READS) continue;
                if (!firstReadTrack) {
                    samples.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                } else {
                    firstReadTrack = false;
                }
                URL fastaUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE);
                URL fastaIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE_INDEX);
                IndexedFastaHandlerThread refSeqRequestHandler = null;
                if (fastaUrl != null && fastaIndexUrl != null) {
                    IndexedFastaDataSource refSeqDataSource = new IndexedFastaDataSource(fastaUrl, fastaIndexUrl);
                    refSeqRequestHandler = new IndexedFastaHandlerThread(refSeqDataSource);
                }
                if (track.interpretation.summaryDatas.size() == 0) {
                    treatmentData = this.createReadDataSource(track.interpretation.primaryData, track.interpretation.indexData, this.tracks);
                    treatmentRequestHandler = new SAMHandlerThread(treatmentData);
                    TrackGroup readGroup = TrackFactory.getReadTrackGroup(this.plot, treatmentRequestHandler, refSeqRequestHandler, track.interpretation.primaryData.getName());
                    track.setTrackGroup(readGroup);
                    samples.addTrackGroup(readGroup);
                    continue;
                }
                treatmentData = this.createReadDataSource(track.interpretation.primaryData, track.interpretation.indexData, this.tracks);
                treatmentRequestHandler = new SAMHandlerThread(treatmentData);
                TabixDataSource symmaryData = new TabixDataSource(dataUrl.getUrl(), null);
                TabixSummaryHandlerThread summaryRequestHandler = new TabixSummaryHandlerThread(symmaryData);
                TrackGroup readGroupWithSummary = TrackFactory.getReadSummaryTrackGroup(this.plot, treatmentRequestHandler, refSeqRequestHandler, track.interpretation.primaryData.getName(), summaryRequestHandler);
                track.setTrackGroup(readGroupWithSummary);
                samples.addTrackGroup(readGroupWithSummary);
            }
            catch (IOException e) {
                this.reportException(e);
            }
            catch (URISyntaxException e) {
                this.reportException(e);
            }
            catch (GBrowserException e) {
                this.reportException(e);
            }
        }
        if (firstReadTrack) {
            samples.setScrollEnabled(false);
            URL fastaUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE);
            URL fastaIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE_INDEX);
            IndexedFastaDataSource refSeqDataSource = null;
            if (fastaUrl != null && fastaIndexUrl != null) {
                try {
                    refSeqDataSource = new IndexedFastaDataSource(fastaUrl, fastaIndexUrl);
                    IndexedFastaHandlerThread refSeqRequestHandler = new IndexedFastaHandlerThread(refSeqDataSource);
                    TrackGroup readGroup = TrackFactory.getReadTrackGroup(this.plot, null, refSeqRequestHandler, this.settings.getGenome().toString());
                    samples.addTrackGroup(readGroup);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.plot.getDataView().addScrollGroup(samples);
        this.plot.getDataView().addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup analysis = new ScrollGroup("Analysis", false);
        boolean firstPeakTrack = true;
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            DataUrl dataUrl = track.interpretation.primaryData;
            switch (track.interpretation.type) {
                case REGIONS: 
                case VCF: 
                case GTF: 
                case CNA_FREQUENCIES: 
                case CNA_CALLS: 
                case CNA_LOGRATIOS: {
                    if (!firstPeakTrack) {
                        analysis.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                        break;
                    }
                    firstPeakTrack = false;
                    break;
                }
            }
            switch (track.interpretation.type) {
                case REGIONS: {
                    LineToRegionConversion conversion;
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    try {
                        conversion = new LineToRegionConversion(dataUrl.getUrl(), new BedLineParser(true));
                        analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, conversion));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case VCF: {
                    LineToRegionConversion conversion;
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    try {
                        conversion = new LineToRegionConversion(dataUrl.getUrl(), new VcfLineParser());
                        analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, conversion));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case GTF: {
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    analysis.setScrollEnabled(true);
                    try {
                        RandomAccessLineDataSource gtfData = new RandomAccessLineDataSource(dataUrl.getUrl());
                        GtfToFeatureConversion gtfConversion = new GtfToFeatureConversion(gtfData, this);
                        analysis.addTrackGroup(TrackFactory.getGeneTrackGroup(this.plot, gtfConversion, null, true));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case CNA_FREQUENCIES: 
                case CNA_CALLS: 
                case CNA_LOGRATIOS: {
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    analysis.setScrollEnabled(true);
                    try {
                        RandomAccessLineDataSource cnaData = new RandomAccessLineDataSource(dataUrl.getUrl());
                        CnaConversion conversion = new CnaConversion(cnaData, this);
                        cnaData.setLineReaderPosition(0L);
                        String header = cnaData.getNextLine();
                        CnaLineParser parser = new CnaLineParser();
                        parser.setLine(header);
                        LinkedList<String> internalSampleNames = parser.getSampleNames();
                        LinkedList<String> sampleNames = this.getSampleNames(internalSampleNames, dataUrl);
                        boolean showFrequencies = track.interpretation.type == TrackType.CNA_FREQUENCIES;
                        boolean showCalls = track.interpretation.type == TrackType.CNA_CALLS;
                        boolean showLogratios = track.interpretation.type == TrackType.CNA_LOGRATIOS;
                        analysis.addTrackGroup(TrackFactory.getCnaTrackGroup(this.plot, conversion, sampleNames, showFrequencies, showCalls, showLogratios));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    catch (IOException e) {
                        this.reportException(e);
                    }
                    catch (GBrowserException e) {
                        this.reportException(e);
                    }
                    break;
                }
            }
        }
        if (analysis.getTrackGroups().size() > 0) {
            this.plot.getDataView().addScrollGroup(analysis);
        }
        SeparatorTrack3D separator2 = new SeparatorTrack3D(0L, Long.MAX_VALUE, false);
        separator2.setView(this.plot.getDataView());
        this.plot.getDataView().addTrackGroup(new TrackGroup(separator2));
        this.plot.initializeTracks();
    }

    public DataSource createReadDataSource(DataUrl data, DataUrl indexData, List<TrackDefinition> tracks) throws IOException, URISyntaxException, GBrowserException {
        DataSource dataSource = null;
        File file = data == null ? null : data.getLocalFile();
        URL fileUrl = file.toURI().toURL();
        if (data.getName().contains(".bam-summary")) {
            dataSource = new TabixSummaryDataSource(fileUrl);
        } else if (data.getName().contains(".bam") || data.getName().contains(".sam")) {
            File indexFile = indexData.getLocalFile();
            URL indexFileUrl = indexFile.toURI().toURL();
            dataSource = new SAMDataSource(fileUrl, indexFileUrl);
        }
        return dataSource;
    }

    public URL getAnnotationUrl(AnnotationManager.Genome genome, AnnotationManager.AnnotationType type) {
        AnnotationManager.GenomeAnnotation annotation = this.annotationManager.getAnnotation(genome, type);
        if (annotation != null) {
            return annotation.getUrl();
        }
        return null;
    }

    public void showVisualisation() {
        if (this.plot != null) {
            this.plot.clean();
        }
        TooltipAugmentedChartPanel chartPanel = new TooltipAugmentedChartPanel();
        this.plot = new GBrowserPlot(chartPanel, true);
        chartPanel.setPlot(this.plot);
        this.plot.getDataView().setBpRegion(new RegionDouble((double)this.settings.getLocation().longValue() - (double)this.settings.getViewSize().longValue() / 2.0, (double)this.settings.getLocation().longValue() + (double)this.settings.getViewSize().longValue() / 2.0, this.settings.getChromosome()));
        this.plot.addDataRegionListener(this.settings);
        this.updateCoverageScale();
        this.updateTracks();
        this.settings.updateTracks();
        chartPanel.setChart(new JFreeChart((Plot)this.plot));
        chartPanel.setCursor(new Cursor(12));
        for (GBrowserView view : this.plot.getViews()) {
            chartPanel.addMouseListener(view);
            chartPanel.addMouseMotionListener(view);
            chartPanel.addMouseWheelListener(view);
        }
        if (this.plotPanel.getComponentCount() == 2) {
            this.plotPanel.remove(1);
        }
        this.setFullHeight(this.settings.isFullHeight());
        this.plotPanel.add((Component)((Object)chartPanel), PLOTPANEL);
        this.plotPanel.addComponentListener(this);
        CardLayout cl = (CardLayout)this.plotPanel.getLayout();
        cl.show(this.plotPanel, PLOTPANEL);
    }

    private GeneIndexActions getGeneIndexActions() {
        if (this.gia == null) {
            this.showDialog("Gene search failed", "Gene search is not initialized, is annotation data missing?", null, true, false, true, false);
        }
        return this.gia;
    }

    public void requestGeneSearch(String gene) {
        this.runBlockingTask("searching gene", new Runnable(){

            @Override
            public void run() {
                int TIME_OUT = 30000;
                int INTERVAL = 100;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() < startTime + (long)TIME_OUT && !GBrowser.this.geneSearchDone) {
                    try {
                        Thread.sleep(INTERVAL);
                    }
                    catch (InterruptedException e) {}
                }
                if (GBrowser.this.geneSearchDone) {
                    GBrowser.this.geneSearchDone = false;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GBrowser.this.showDialog("Search failed", "Unexpected error happened in the search. Please inform the developers if the problem persists.", null, true, false, false, false);
                        }
                    });
                }
            }
        });
        this.getGeneIndexActions().requestLocation(gene, new GeneIndexActions.GeneLocationListener(){

            @Override
            public void geneLocation(Region geneLocation) {
                GBrowser.this.geneSearchDone = true;
                if (geneLocation == null) {
                    GBrowser.this.settings.processLocationPanelInput();
                    GBrowser.this.showDialog("Not found", "Gene was not found", null, false, false, false, false);
                } else {
                    Chromosome resultChr = new Chromosome(geneLocation.start.chr);
                    if (GBrowser.this.settings.setChromosome(resultChr)) {
                        GBrowser.this.setLocation(GBrowser.this.settings.getChromosome(), geneLocation.start.bp, geneLocation.end.bp);
                    } else {
                        GBrowser.this.showDialog("Different chromosome", "Searched gene was found from chromosome " + resultChr + " but there is no data for that chromosome", "" + geneLocation, true, false, false, false);
                    }
                }
            }
        });
    }

    public void setLocation(Chromosome chr, Long start, Long end) {
        this.settings.setChromosome(chr);
        if (end == null) {
            end = start;
        }
        this.settings.setCoordinateFields((end + start) / 2L, (end - start) * 2L);
        this.plot.moveDataBpRegion(this.settings.getChromosome(), this.settings.getLocation(), this.settings.getViewSize());
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    public void removeVisualisation() {
        this.plotPanel.removeComponentListener(this);
        this.plotPanel.removeAll();
        if (this.plot != null) {
            this.plot.clean();
            this.plot = null;
        }
        if (this.tracks != null) {
            this.tracks.clear();
        }
        this.gia = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Chromosome> getChromosomeNames() throws IOException {
        TreeSet<String> chromosomeNames = new TreeSet<String>();
        for (Interpretation interpretation : this.interpretations) {
            if (interpretation.type != TrackType.READS) continue;
            InputStream in = null;
            try {
                in = interpretation.primaryData.getInputStream();
                chromosomeNames.addAll(SamBamUtils.readChromosomeNames(in));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeIfPossible(in);
            }
        }
        if (chromosomeNames.isEmpty()) {
            for (Interpretation interpretation : this.getInterpretations()) {
                boolean isCna;
                boolean isBed = interpretation.type == TrackType.REGIONS;
                boolean isVcf = interpretation.type == TrackType.VCF;
                boolean isGtf = interpretation.type == TrackType.GTF;
                boolean bl = isCna = interpretation.type == TrackType.CNA_FREQUENCIES || interpretation.type == TrackType.CNA_CALLS || interpretation.type == TrackType.CNA_LOGRATIOS;
                if (!isBed && !isVcf && !isGtf && !isCna) continue;
                try {
                    DataUrl data = interpretation.primaryData;
                    ChromosomeBinarySearch chrSearch = null;
                    if (isBed) {
                        chrSearch = new ChromosomeBinarySearch(data.getUrl(), new BedLineParser(true));
                    } else if (isVcf) {
                        chrSearch = new ChromosomeBinarySearch(data.getUrl(), new VcfLineParser());
                    } else if (isGtf) {
                        chrSearch = new ChromosomeBinarySearch(data.getUrl(), new GtfLineParser());
                    } else if (isCna) {
                        chrSearch = new ChromosomeBinarySearch(data.getUrl(), new CnaLineParser());
                    }
                    for (Chromosome chr : chrSearch.getChromosomes()) {
                        chromosomeNames.add(chr.toNormalisedString());
                    }
                }
                catch (UnsortedDataException e) {
                    this.showDialog("Unsorted data", e.getMessage(), null, true, false, true, true);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (GBrowserException e) {
                    e.printStackTrace();
                }
            }
        }
        LinkedList<Chromosome> chromosomes = new LinkedList<Chromosome>();
        for (String chromosomeName : chromosomeNames) {
            chromosomes.add(new Chromosome(chromosomeName));
        }
        Collections.sort(chromosomes);
        return chromosomes;
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.plot.redraw();
    }

    public List<Interpretation> getInterpretations() {
        return this.interpretations;
    }

    public String getExternalLinkUrl(AnnotationManager.AnnotationType browser) {
        this.settings.getGenome();
        URL url = this.annotationManager.getAnnotation(this.settings.getGenome(), browser).getUrl();
        if (url != null && this.plot != null && this.plot.getDataView() != null && this.plot.getDataView().getBpRegion() != null) {
            String stringUrl = url.toString();
            Region region = this.plot.getDataView().getBpRegion();
            stringUrl = stringUrl.replace("[CHR]", region.start.chr.toNormalisedString());
            stringUrl = stringUrl.replace("[START]", region.start.bp.toString());
            stringUrl = stringUrl.replace("[END]", region.end.bp.toString());
            return stringUrl;
        }
        return "";
    }

    public void openExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    public JPanel getParameterPanel() {
        return this.settings.getParameterPanel();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public List<TrackDefinition> getTracks() {
        return this.tracks;
    }

    public void reportException(Exception e) {
        e.printStackTrace();
    }

    public void showDialog(String title, String message, String details, boolean warning, boolean dialogShowDetails, boolean modal, boolean closeBrowser) {
        System.out.println("showDialog not implemented: " + title + "\t" + message + "\t" + details);
    }

    public void runBlockingTask(String taskName, Runnable runnable) {
        System.out.println("runBlockingTask: " + taskName);
        new Thread(runnable).start();
    }

    public void initialiseUserDatas() throws IOException {
    }

    public ImageIcon getIcon(String path) {
        System.out.println("getIcon not implemented");
        return new ImageIcon();
    }

    public void openDownloadAnnotationsDialog(AnnotationManager.Genome genome) {
        try {
            this.getAnnotationManager().downloadAnnotations(genome);
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    public URL getRemoteAnnotationsUrl() throws Exception {
        System.out.println("getRemoteAnnotationsUrl not implemented");
        return null;
    }

    public File getLocalAnnotationDir() throws IOException {
        System.out.println("getLocalAnnotationDir not implemented");
        return null;
    }

    public LinkedList<String> getSampleNames(LinkedList<String> internalSampleNames, DataUrl dataUrl) {
        return internalSampleNames;
    }

    public void updateData() {
        this.updateTracks();
        this.settings.updateVisibilityForTracks();
        this.plot.updateData();
    }

    public static class TrackDefinition {
        public Interpretation interpretation;
        public JCheckBox checkBox;
        public String name;
        public TrackGroup trackGroup = null;

        public TrackDefinition(String name, Interpretation interpretation) {
            this.name = name;
            this.interpretation = interpretation;
        }

        public void setTrackGroup(TrackGroup trackGroup) {
            this.trackGroup = trackGroup;
        }
    }

    public static class Interpretation {
        private TrackType type;
        private List<DataUrl> summaryDatas = new LinkedList<DataUrl>();
        private DataUrl primaryData;
        private DataUrl indexData;
        private String name;

        public Interpretation(TrackType type, DataUrl primaryData) {
            this.type = type;
            this.primaryData = primaryData;
        }

        public TrackType getType() {
            return this.type;
        }

        public void setType(TrackType type) {
            this.type = type;
        }

        public List<DataUrl> getSummaryDatas() {
            return this.summaryDatas;
        }

        public void setSummaryDatas(List<DataUrl> summaryDatas) {
            this.summaryDatas = summaryDatas;
        }

        public DataUrl getPrimaryData() {
            return this.primaryData;
        }

        public void setPrimaryData(DataUrl primaryData) {
            this.primaryData = primaryData;
        }

        public DataUrl getIndexData() {
            return this.indexData;
        }

        public void setIndexData(DataUrl indexData) {
            this.indexData = indexData;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.primaryData.getName();
        }
    }

    public static class DataUrl {
        private URL url;
        private String name;

        public DataUrl(URL data, String name) {
            this.url = data;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public InputStream getInputStream() throws IOException, URISyntaxException {
            return new FileInputStream(new File(this.url.toURI()));
        }

        public File getLocalFile() throws IOException, URISyntaxException {
            return new File(this.url.toURI());
        }

        public URL getUrl() {
            return this.url;
        }
    }

    public static enum TrackType {
        CYTOBANDS(false),
        GENES(false),
        TRANSCRIPTS(true),
        REFERENCE(true),
        REGIONS(true),
        READS(true),
        HIDDEN(false),
        VCF(true),
        GTF(true),
        CNA_CALLS(true),
        CNA_LOGRATIOS(true),
        CNA_FREQUENCIES(true);

        public boolean isToggleable;

        private TrackType(boolean toggleable) {
            this.isToggleable = toggleable;
        }
    }
}

