/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;

public class PercentageParameter
extends Parameter {
    private final Integer minValue;
    private final Integer maxValue;
    private Integer value;

    public PercentageParameter(String id, String displayName, int initValue) throws IllegalArgumentException {
        this(id, displayName, displayName, 0, 100, initValue);
    }

    public PercentageParameter(String id, String displayName, String description, Integer minValue, Integer maxValue, Integer initValue) throws IllegalArgumentException {
        super(id, displayName, description);
        if (minValue < 0) {
            throw new IllegalArgumentException("Minimum value for percentage parameter " + this.getID() + " cannot be less than zero.");
        }
        if (maxValue > 100) {
            throw new IllegalArgumentException("Maximum value for percentage parameter " + this.getID() + " cannot be over 100.");
        }
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new IllegalArgumentException("Minimum value for percentage parameter " + this.getID() + " cannot be bigger than the maximum value.");
        }
        this.maxValue = maxValue;
        this.setIntegerValue(initValue);
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public Integer getIntegerValue() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setIntegerValue(int newValue) {
        if (newValue < this.minValue || newValue > this.maxValue) {
            throw new IllegalArgumentException("Initial value for percentage parameter " + this.getID() + " must be within given limits.");
        }
        this.value = newValue;
    }

    @Override
    public void setValue(Object newValue) {
        if (this.checkValidityOf(newValue)) {
            this.value = (Integer)newValue;
            return;
        }
        throw new IllegalArgumentException(newValue + " is an illegal " + "value for percentage parameter \"" + this.getID() + "\" (" + this.minValue + " ... " + this.maxValue + ")");
    }

    @Override
    public boolean checkValidityOf(Object valueObject) {
        if (!(valueObject instanceof Integer)) {
            return false;
        }
        Integer intValue = (Integer)valueObject;
        return intValue >= this.minValue && intValue <= this.maxValue;
    }

    @Override
    public String toString() {
        return this.getID() + ": " + this.value + "%";
    }

    @Override
    public String getValueAsJava() {
        return "" + this.value;
    }

    @Override
    public void parseValue(String stringValue) throws IllegalArgumentException {
        try {
            this.setValue(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse String value \"" + stringValue + "\"");
        }
    }

    @Override
    public String getValueAsString() {
        return this.value.toString();
    }
}

