/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.shell;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolDescriptionGenerator;
import fi.csc.microarray.analyser.shell.ShellAnalysisJob;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShellAnalysisHandler
implements AnalysisHandler {
    private String DIRECTORY_NAME = "shell";
    private String toolPath;
    private static final Logger logger = Logger.getLogger(ShellAnalysisHandler.class);

    public ShellAnalysisHandler(HashMap<String, String> parameters) {
        this.toolPath = parameters.get("toolPath");
    }

    @Override
    public AnalysisJob createAnalysisJob(JobMessage jobMessage, ToolDescription description, ResultCallback resultCallback) throws AnalysisException {
        ShellAnalysisJob analysisJob = new ShellAnalysisJob();
        analysisJob.construct(jobMessage, description, resultCallback);
        return analysisJob;
    }

    @Override
    public ToolDescription handle(File moduleDir, String descriptionFilename, Map<String, String> params) throws AnalysisException {
        ToolDescription description = null;
        try {
            String sadlString;
            File sadlFile = new File(moduleDir, this.toolPath + File.separator + descriptionFilename);
            File toolFile = null;
            if (sadlFile.exists()) {
                sadlString = Files.fileToString(sadlFile);
                toolFile = sadlFile;
            } else {
                InputStream scriptSource = this.getClass().getResourceAsStream("/" + this.DIRECTORY_NAME + "/" + descriptionFilename);
                sadlString = Files.inputStreamToString(scriptSource);
            }
            description = new ToolDescriptionGenerator().generate(new ChipsterSADLParser().parse(sadlString), this);
            description.setSADL(sadlString);
            description.setSourceCode(sadlString);
            description.setToolFile(toolFile);
            description.setModuleDir(moduleDir);
            description.setCommand(params.get("executable"));
            description.setConfigParameters(params);
            logger.info((Object)("successfully loaded shell analysis description " + descriptionFilename));
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
        return description;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isUptodate(ToolDescription description) {
        File scriptFile = description.getToolFile();
        if (scriptFile != null) {
            return scriptFile.lastModified() <= description.getCreationTime();
        }
        return true;
    }
}

