/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.messaging.JobState;
import java.io.File;

public class SortBed
extends JavaAnalysisJobBase {
    public static final ChromosomeNormaliser CHROMOSOME_NORMALISER = new ChromosomeNormaliser(){

        @Override
        public String normaliseChromosome(String chromosomeName) {
            String SEPARATOR = ".";
            if (chromosomeName.contains(SEPARATOR)) {
                chromosomeName = chromosomeName.substring(0, chromosomeName.indexOf(SEPARATOR));
            }
            return chromosomeName;
        }
    };

    @Override
    public String getSADL() {
        return "TOOL SortBed.java: \"Sort BED\" (Sort a BED file by chromosome and start position.)\nINPUT regions.bed: \"BED file\" TYPE GENERIC\nOUTPUT sorted.bed: \"Sorted BED file\"\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobWorkDir, this.analysis.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.analysis.getOutputFiles().get(0).getFileName().getID());
            new TsvSorter().sort(inputFile, outputFile, CHROMOSOME_NORMALISER, BedLineParser.Column.CHROMOSOME.ordinal(), BedLineParser.Column.START.ordinal(), new BedLineParser(false));
        }
        catch (Exception e) {
            this.updateState(JobState.FAILED, e.getMessage());
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }
}

