/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.bed.BEDFeature;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.interval.Interval;
import org.broad.tribble.index.interval.IntervalTree;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IntervalTreeTest {
    static IntervalTree tree;

    @BeforeClass
    public static void setupTree() {
        tree = new IntervalTree();
        tree.insert(new Interval(0, 3, null));
        tree.insert(new Interval(5, 8, null));
        tree.insert(new Interval(6, 10, null));
        tree.insert(new Interval(8, 9, null));
        tree.insert(new Interval(15, 23, null));
        tree.insert(new Interval(16, 21, null));
        tree.insert(new Interval(17, 19, null));
        tree.insert(new Interval(19, 20, null));
        tree.insert(new Interval(25, 30, null));
        tree.insert(new Interval(26, 27, null));
    }

    @Test
    public void testSearch() {
        Interval queryInterval = new Interval(1, 2);
        List<Interval> intervals = tree.findOverlapping(queryInterval);
        org.testng.Assert.assertNotNull(intervals);
        for (Interval iv : intervals) {
            org.testng.Assert.assertTrue((boolean)queryInterval.overlaps(iv));
        }
    }

    @Test
    public void testBed() throws Exception {
        String bedFile = "test/data/index/chrY_Y4_small.bed";
        tree = new IntervalTree();
        org.testng.Assert.assertTrue((boolean)tree.isValid());
        BufferedReader br = new BufferedReader(new FileReader(bedFile));
        String nextLine = "";
        while ((nextLine = br.readLine()) != null) {
            String[] tokens;
            if (nextLine.startsWith("#") || nextLine.startsWith("track") || (tokens = nextLine.split("\t")).length <= 2) continue;
            int start = Integer.parseInt(tokens[1]);
            int end = Integer.parseInt(tokens[2]);
            tree.insert(new Interval(start, end));
        }
        Interval searchInterval = new Interval(2782632, 2782732);
        List<Interval> iv = tree.findOverlapping(searchInterval);
        for (Interval i : iv) {
            org.testng.Assert.assertTrue((boolean)i.overlaps(searchInterval));
        }
        br.close();
    }

    @Test
    public void testOverlappingFeatures() throws Exception {
        HashSet<String> names = new HashSet<String>(Arrays.asList("Hs.134602", "Hs.620337", "Hs.609465", "Hs.623987", "Hs.594545", "LONG_FEATURE"));
        String bedFile = "test/data/bed/Unigene.sample.bed";
        String chr = "chr2";
        int start = 179266309;
        int end = 179303488;
        int expectedCount = 6;
        int batchSize = 1;
        Index idx = IndexFactory.createIntervalIndex(new File(bedFile), new BEDCodec(), batchSize);
        AbstractFeatureReader bfr = AbstractFeatureReader.getFeatureReader(bedFile, (FeatureCodec)new BEDCodec(), idx);
        CloseableTribbleIterator iter = bfr.query(chr, start, end);
        int countInterval = 0;
        while (iter.hasNext()) {
            BEDFeature feature = (BEDFeature)iter.next();
            Assert.assertTrue((feature.getEnd() >= start && feature.getStart() <= end ? 1 : 0) != 0);
            Assert.assertTrue((boolean)names.contains(feature.getName()));
            ++countInterval;
        }
        org.testng.Assert.assertEquals((int)countInterval, (int)expectedCount);
    }
}

