/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.Tribble;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.example.ExampleBinaryCodec;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.ParsingUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureReaderTest {
    private static final File asciiBedFile = new File("test/data/test.bed");
    private static final File binaryBedFile = new File("test/data/test.binary.bed");
    private static final File tabixBedFile = new File("test/data/test.tabix.bed.gz");

    @BeforeClass
    public void setup() throws IOException {
        ExampleBinaryCodec.convertToBinaryTest(asciiBedFile, binaryBedFile, new BEDCodec());
    }

    @AfterClass
    public void teardown() throws Exception {
    }

    @DataProvider(name="indexProvider")
    public Object[][] createData1() {
        return new Object[][]{{asciiBedFile, IndexFactory.IndexType.LINEAR, new BEDCodec()}, {asciiBedFile, IndexFactory.IndexType.INTERVAL_TREE, new BEDCodec()}, {tabixBedFile, IndexFactory.IndexType.TABIX, new BEDCodec()}, {binaryBedFile, IndexFactory.IndexType.LINEAR, new ExampleBinaryCodec()}, {binaryBedFile, IndexFactory.IndexType.INTERVAL_TREE, new ExampleBinaryCodec()}};
    }

    @Test(dataProvider="indexProvider")
    public void testBedQuery(File featureFile, IndexFactory.IndexType indexType, FeatureCodec<Feature> codec) throws IOException {
        AbstractFeatureReader<Feature> reader = this.getReader(featureFile, indexType, codec);
        this.testQuery(reader, "chr1", 1, 500, 3);
        this.testQuery(reader, "chr1", 1, 200, 1);
        this.testQuery(reader, "chr1", 1, 201, 2);
        this.testQuery(reader, "chr1", 500, 600, 0);
        this.testQuery(reader, "chr1", 100000, 100010, 1);
        this.testQuery(reader, "chr1", 100000, 100000, 0);
        this.testQuery(reader, "chr1", 100001, 100001, 1);
        this.testQuery(reader, "chr1", 100005, 100006, 1);
        this.testQuery(reader, "chr1", 100009, 100011, 1);
        this.testQuery(reader, "chr1", 100010, 100010, 1);
        this.testQuery(reader, "chr1", 100011, 100011, 0);
        this.testQuery(reader, "chr2", 1, 100, 2);
        this.testQuery(reader, "chr2", 1, 10, 1);
        this.testQuery(reader, "chr2", 15, 16, 0);
        this.testQuery(reader, "chr3", 1, 201, 0);
        reader.close();
    }

    @Test(dataProvider="indexProvider")
    public void testLargeNumberOfQueries(File featureFile, IndexFactory.IndexType indexType, FeatureCodec<Feature> codec) throws IOException {
        AbstractFeatureReader<Feature> reader = this.getReader(featureFile, indexType, codec);
        List<Integer> sites = Arrays.asList(500, 200, 201, 600, 100000);
        int i = 0;
        while (i < 2000) {
            for (int start : sites) {
                int end;
                if (start >= (end = start + 1)) continue;
                for (String chr : Arrays.asList("chr1", "chr2", "chr3")) {
                    CloseableTribbleIterator iter = reader.query(chr, start, end);
                    Assert.assertTrue((iter != null ? 1 : 0) != 0, (String)"Failed to create non-null iterator");
                    iter.close();
                }
            }
            ++i;
        }
        reader.close();
    }

    private final void testQuery(AbstractFeatureReader<Feature> reader, String chr, int start, int stop, int expectedNumRecords) throws IOException {
        CloseableTribbleIterator iter = reader.query(chr, start, stop);
        int count = 0;
        while (iter.hasNext()) {
            Feature f = (Feature)iter.next();
            Assert.assertTrue((f.getEnd() >= start && f.getStart() <= stop ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)expectedNumRecords);
    }

    @Test(dataProvider="indexProvider")
    public void testBedNames(File featureFile, IndexFactory.IndexType indexType, FeatureCodec<Feature> codec) throws IOException {
        AbstractFeatureReader<Feature> reader = this.getReader(featureFile, indexType, codec);
        String[] expectedSequences = new String[]{"chr1", "chr2"};
        List<String> seqNames = reader.getSequenceNames();
        Assert.assertEquals((int)seqNames.size(), (int)expectedSequences.length, (String)("Expected sequences " + ParsingUtils.join(",", expectedSequences) + " but saw " + ParsingUtils.join(",", seqNames)));
        String[] stringArray = expectedSequences;
        int n = expectedSequences.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Assert.assertTrue((boolean)seqNames.contains(s));
            ++n2;
        }
    }

    private final AbstractFeatureReader<Feature> getReader(File featureFile, IndexFactory.IndexType indexType, FeatureCodec<Feature> codec) throws IOException {
        if (indexType.canCreate()) {
            File idxFile = Tribble.indexFile(featureFile);
            if (idxFile.exists()) {
                idxFile.delete();
            }
            Index idx = IndexFactory.createIndex(featureFile, codec, indexType);
            IndexFactory.writeIndex(idx, idxFile);
            idxFile.deleteOnExit();
        }
        return AbstractFeatureReader.getFeatureReader(featureFile.getAbsolutePath(), codec);
    }
}

