/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;

class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class propertyEditorClass;
    private Class propertyType;
    private MethodParameter writeMethodParameter;

    public GenericTypeAwarePropertyDescriptor(Class beanClass, String propertyName, Method readMethod, Method writeMethod, Class propertyEditorClass) throws IntrospectionException {
        super(propertyName, null, null);
        this.beanClass = beanClass;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.propertyEditorClass = propertyEditorClass;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public synchronized Class getPropertyType() {
        if (this.propertyType == null) {
            MethodParameter writeMethodParam;
            this.propertyType = this.readMethod != null ? GenericTypeResolver.resolveReturnType(this.readMethod, this.beanClass) : ((writeMethodParam = this.getWriteMethodParameter()) != null ? writeMethodParam.getParameterType() : super.getPropertyType());
        }
        return this.propertyType;
    }

    public synchronized MethodParameter getWriteMethodParameter() {
        if (this.writeMethod == null) {
            return null;
        }
        if (this.writeMethodParameter == null) {
            this.writeMethodParameter = new MethodParameter(this.writeMethod, 0);
            GenericTypeResolver.resolveParameterType(this.writeMethodParameter, this.beanClass);
        }
        return this.writeMethodParameter;
    }
}

