/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import org.jfree.chart.labels.HCToolTipGenerator;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.HeatMap;

public class StandardHCToolTipGenerator
implements HCToolTipGenerator {
    public String generateToolTip(HCTreeNodeInfo node) {
        return node.toString();
    }

    public String generateToolTip(HeatMap heatmap, DataRange rowRange, DataRange columnRange) {
        int maxColumn;
        int minColumn;
        int maxRow;
        int minRow;
        try {
            minRow = rowRange.getLeftBound();
            maxRow = rowRange.getRightBound();
            minColumn = columnRange.getLeftBound();
            maxColumn = columnRange.getRightBound();
        }
        catch (Exception e) {
            return "This block contains no data.";
        }
        if (minRow == maxRow && minColumn == maxColumn) {
            return "(" + minRow + "," + minColumn + ") = " + heatmap.get(minRow, minColumn);
        }
        double averageValue = 0.0;
        int blockCount = 0;
        for (int rowCounter = minRow; rowCounter <= maxRow; ++rowCounter) {
            int columnCounter = minColumn;
            while (columnCounter <= maxColumn) {
                averageValue += heatmap.get(rowCounter, columnCounter);
                ++columnCounter;
                ++blockCount;
            }
        }
        return "(" + minRow + "," + minColumn + ") .. " + "(" + maxRow + "," + maxColumn + ") = " + (averageValue /= (double)blockCount) + " (contains " + blockCount + " blocks)";
    }
}

