/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.programs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.JTextArea;

public class RunEmbossApplication2 {
    private Process p;
    private StringBuffer stdout = new StringBuffer();
    private StringBuffer stderr = new StringBuffer();
    private File project;
    private String status;
    private StdoutHandler stdouth;
    private StderrHandler stderrh;
    private JTextArea textArea;

    public RunEmbossApplication2(String[] stringArray, String[] stringArray2, File file) {
        this.project = file;
        this.status = "0";
        Runtime runtime = Runtime.getRuntime();
        try {
            this.p = runtime.exec(stringArray, stringArray2, file);
            this.stdouth = new StdoutHandler(this);
            this.stderrh = new StderrHandler(this);
            this.stdouth.start();
            this.stderrh.start();
        }
        catch (IOException iOException) {
            System.out.println("RunEmbossApplication2 Error executing: " + stringArray);
            this.status = "1";
        }
    }

    public RunEmbossApplication2(String string, String[] stringArray, File file) {
        this.project = file;
        this.status = "0";
        Runtime runtime = Runtime.getRuntime();
        try {
            this.p = runtime.exec(string, stringArray, file);
            this.stdouth = new StdoutHandler(this);
            this.stderrh = new StderrHandler(this);
            this.stdouth.start();
            this.stderrh.start();
        }
        catch (IOException iOException) {
            System.out.println("RunEmbossApplication2 Error executing: " + string);
            this.status = "1";
        }
    }

    public RunEmbossApplication2(String string, String[] stringArray, File file, JTextArea jTextArea) {
        this(string, stringArray, file);
        this.textArea = jTextArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcessStderr() {
        BufferedInputStream bufferedInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.p.getErrorStream());
            bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            char[] cArray = new char[100];
            int n = 0;
            while ((n = bufferedReader.read(cArray, 0, 100)) != -1) {
                this.stderr = this.stderr.append(new String(cArray, 0, n));
            }
        }
        catch (IOException iOException) {
            System.err.println("RunEmbossApplication2: Error in collecting standard out");
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("RunEmbossApplication2: Error closing stream");
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("RunEmbossApplication2: Error closing reader");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcessStdout() {
        BufferedInputStream bufferedInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.p.getInputStream());
            bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            char[] cArray = new char[100];
            int n = 0;
            while ((n = bufferedReader.read(cArray, 0, 100)) != -1) {
                String string = new String(cArray, 0, n);
                this.stdout = this.stdout.append(string);
                if (this.textArea == null) continue;
                this.textArea.append(string);
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
        }
        catch (IOException iOException) {
            System.err.println("RunEmbossApplication2: Error in collecting standard out");
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("RunEmbossApplication2: Error closing stream");
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("RunEmbossApplication2: Error closing reader");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStdout() {
        if (this.project != null) {
            PrintWriter printWriter = null;
            String string = "";
            try {
                string = this.project.getCanonicalPath() + "/application_stdout";
                File file = new File(string);
                if (!file.exists()) {
                    file.createNewFile();
                }
                printWriter = new PrintWriter(new FileWriter(string, true));
                printWriter.println(this.stdout);
            }
            catch (IOException iOException) {
                System.err.println("RunEmbossApplication2: Error writing" + string);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    public String getProcessStdout() {
        try {
            while (this.stdouth.isAlive()) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return new String(this.stdout.toString().trim());
    }

    public String getProcessStderr() {
        try {
            while (this.stderrh.isAlive()) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return new String(this.stderr.toString().trim());
    }

    public void waitFor() {
        try {
            this.p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public Process getProcess() {
        return this.p;
    }

    public String getStatus() {
        return this.status;
    }

    class StderrHandler
    extends Thread {
        RunEmbossApplication2 rea;

        protected StderrHandler(RunEmbossApplication2 runEmbossApplication22) {
            this.rea = runEmbossApplication22;
        }

        public void run() {
            this.rea.readProcessStderr();
        }
    }

    class StdoutHandler
    extends Thread {
        RunEmbossApplication2 rea;

        protected StdoutHandler(RunEmbossApplication2 runEmbossApplication22) {
            this.rea = runEmbossApplication22;
        }

        public void run() {
            this.rea.readProcessStdout();
        }
    }
}

