/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Color;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import org.emboss.jemboss.gui.SequenceData;

public class TextFieldSink
extends JTextField
implements DropTargetListener {
    protected static Border dropBorder = new BevelBorder(1);
    protected static Border endBorder = BorderFactory.createLineBorder(Color.black);

    public TextFieldSink() {
        this.setDropTarget(new DropTarget(this, this));
    }

    public void pasteText() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(string);
            } else {
                this.getToolkit().beep();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.getToolkit().beep();
        }
        catch (IOException iOException) {
            this.getToolkit().beep();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            dropTargetDragEvent.acceptDrag(3);
            this.setBorder(dropBorder);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setBorder(endBorder);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.setBorder(endBorder);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDropEvent.acceptDrop(3);
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(string);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {}
        } else if (transferable.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            dropTargetDropEvent.acceptDrop(3);
            try {
                SequenceData sequenceData = (SequenceData)transferable.getTransferData(SequenceData.SEQUENCEDATA);
                String string = sequenceData.s_name;
                if (sequenceData.s_listFile.booleanValue()) {
                    string = "@".concat(string);
                }
                this.replaceSelection(string);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {}
        } else {
            dropTargetDropEvent.rejectDrop();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

