/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Dimension;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.PlafMacros;
import org.emboss.jemboss.parser.ParseAcd;

public class AlignFormat {
    private static String[] align_msf = new String[]{"unknown", "multiple", "simple", "fasta", "msf", "srs"};
    private static String[] align_pairwise = new String[]{"unknown", "multiple", "simple", "fasta", "msf", "srs", "pair", "markx0", "markx1", "markx2", "markx3", "markx10", "srspair", "score"};
    private JembossComboPopup cp;
    private String def;
    private boolean lpair;

    public AlignFormat(ParseAcd parseAcd, int n) {
        this.lpair = this.isPairWise(parseAcd, n);
        this.cp = new JembossComboPopup(this.getAlignFormats(this.lpair));
        int n2 = parseAcd.getNumofParams(n);
        for (int i = 0; i < n2; ++i) {
            if (!parseAcd.getParameterAttribute(n, i).equals("aformat")) continue;
            this.def = parseAcd.getParamValueStr(n, i).toLowerCase();
            this.cp.setSelectedItem(this.def);
        }
        Dimension dimension = this.cp.getPreferredSize();
        dimension = new Dimension(150, (int)dimension.getHeight());
        this.cp.setMaximumSize(dimension);
        this.cp.setPreferredSize(dimension);
    }

    public AlignFormat(String string, boolean bl) {
        this.def = string;
        this.lpair = bl;
        this.cp = new JembossComboPopup(this.getAlignFormats(bl));
        this.cp.setSelectedItem(string);
        Dimension dimension = this.cp.getPreferredSize();
        dimension = new Dimension(150, (int)dimension.getHeight());
        this.cp.setMaximumSize(dimension);
        this.cp.setPreferredSize(dimension);
    }

    public JembossComboPopup getComboPopup() {
        return this.cp;
    }

    public String getDefaultFormat() {
        return this.def;
    }

    private String[] getAlignFormats(boolean bl) {
        if (bl) {
            return align_pairwise;
        }
        return align_msf;
    }

    public String getAlignFormat() {
        String string = " -aformat " + this.cp.getSelectedItem();
        return string;
    }

    private boolean isPairWise(ParseAcd parseAcd, int n) {
        for (int i = 0; i < n; ++i) {
            if (!parseAcd.getParameterAttribute(i, 0).equalsIgnoreCase("seqset")) continue;
            return false;
        }
        return true;
    }

    public String getToolTip() {
        String string = PlafMacros.getLineSeparator();
        String string2 = "unknown - synonym for simple format." + string + "multiple - synonym for simple format." + string + "simple - displays the sequence names and positions and" + string + "puts the markup line underneath the sequences." + string + "fasta - Fasta sequence format with gaps" + string + "msf - MSF sequence format." + string + "srs - shows the sequence ID name and position." + string;
        if (this.lpair) {
            return string2 + string + "pair - default format used with only 2 sequences." + string + "markx0 - default output format for FASTA programs." + string + "markx1 - alternative format for FASTA programs in which" + string + "identities are not marked. Conservative replacements are" + string + "denoted by 'x' and non-conservative substitutions by 'X'." + string + "markx2 - alternative format for FASTA programs in which" + string + "residues in the second sequence are only shown if they" + string + "are different from the first." + string + "markx3 - alternative format for FASTA programs in which" + string + "the sequences are displayed in FASTA format. These can" + string + "be used to build a primitive multiple alignment." + string + "markx10 - alternative format for FASTA programs in which" + string + "the sequences are displayed in FASTA format and the" + string + "sequence length, alignment start and stop is given in" + string + "in lines starting with a semi colon after the title line" + string + "srspair - similar in style to pair format." + string + "score - does not display the sequence alignment. Only" + string + "shows names of the sequences, length of the alignment and" + string + "the score in brackets.";
        }
        return string2;
    }
}

