/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Service;
import org.apache.camel.util.TimeoutMap;
import org.apache.camel.util.TimeoutMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeoutMap<K, V>
implements TimeoutMap<K, V>,
Runnable,
Service {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private final ConcurrentMap<K, TimeoutMapEntry<K, V>> map = new ConcurrentHashMap<K, TimeoutMapEntry<K, V>>();
    private final ScheduledExecutorService executor;
    private final long purgePollTime;
    private final long initialDelay = 1000L;
    private final Lock lock = new ReentrantLock();
    private boolean useLock = true;

    public DefaultTimeoutMap() {
        this(null, 1000L);
    }

    public DefaultTimeoutMap(boolean useLock) {
        this(null, 1000L, useLock);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        this(executor, requestMapPollTimeMillis, true);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis, boolean useLock) {
        this.executor = executor;
        this.purgePollTime = requestMapPollTimeMillis;
        this.useLock = useLock;
        this.schedulePoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        TimeoutMapEntry entry;
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            entry = (TimeoutMapEntry)this.map.get(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            this.updateExpireTime(entry);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long timeoutMillis) {
        TimeoutMapEntry<K, V> entry = new TimeoutMapEntry<K, V>(key, value, timeoutMillis);
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            this.map.put(key, entry);
            this.updateExpireTime(entry);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K id) {
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            this.map.remove(id);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getKeys() {
        Object[] keys;
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            Set keySet = this.map.keySet();
            keys = new Object[keySet.size()];
            keySet.toArray(keys);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
        return keys;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void run() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Running purge task to see if any entries has been timed out");
        }
        try {
            this.purge();
        }
        catch (Throwable t) {
            this.log.error((Object)"Exception occurred during purge task", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("There are " + this.map.size() + " in the timeout map"));
        }
        long now = this.currentTime();
        ArrayList expired = new ArrayList();
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                if (((TimeoutMapEntry)entry.getValue()).getExpireTime() >= now || !this.isValidForEviction((TimeoutMapEntry)entry.getValue())) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Evicting inactive request for correlationID: " + entry));
                }
                expired.add(entry.getValue());
            }
            if (!expired.isEmpty()) {
                Collections.sort(expired, new Comparator<TimeoutMapEntry<K, V>>(){

                    @Override
                    public int compare(TimeoutMapEntry<K, V> a, TimeoutMapEntry<K, V> b) {
                        long diff = a.getExpireTime() - b.getExpireTime();
                        if (diff == 0L) {
                            return 0;
                        }
                        return diff > 0L ? 1 : -1;
                    }
                });
                ArrayList evicts = new ArrayList(expired.size());
                try {
                    for (TimeoutMapEntry entry : expired) {
                        boolean evict = this.onEviction(entry.getKey(), entry.getValue());
                        if (!evict) continue;
                        evicts.add(entry.getKey());
                    }
                }
                finally {
                    for (Object key : evicts) {
                        this.map.remove(key);
                    }
                }
            }
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
    }

    public long getPurgePollTime() {
        return this.purgePollTime;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    protected void schedulePoll() {
        if (this.executor != null) {
            this.executor.scheduleWithFixedDelay(this, 1000L, this.purgePollTime, TimeUnit.MILLISECONDS);
        }
    }

    protected boolean isValidForEviction(TimeoutMapEntry<K, V> entry) {
        return true;
    }

    @Override
    public boolean onEviction(K key, V value) {
        return true;
    }

    protected void updateExpireTime(TimeoutMapEntry entry) {
        long now = this.currentTime();
        entry.setExpireTime(entry.getTimeout() + now);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.map.clear();
    }
}

