/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SedaConsumer
extends ServiceSupport
implements Consumer,
Runnable,
ShutdownAware {
    private static final transient Log LOG = LogFactory.getLog(SedaConsumer.class);
    private SedaEndpoint endpoint;
    private AsyncProcessor processor;
    private ExecutorService executor;
    private MulticastProcessor multicast;
    private ExceptionHandler exceptionHandler;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorTypeConverter.convert(processor);
    }

    public String toString() {
        return "SedaConsumer[" + this.endpoint.getEndpointUri() + "]";
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        return this.endpoint.getQueue().size();
    }

    public void run() {
        BlockingQueue<Exchange> queue = this.endpoint.getQueue();
        while (queue != null && this.isRunAllowed()) {
            Exchange exchange;
            try {
                exchange = queue.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
                continue;
            }
            if (exchange == null) continue;
            if (this.isRunAllowed()) {
                try {
                    this.sendToConsumers(exchange);
                    if (exchange.getException() == null) continue;
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                }
                catch (Exception e) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                }
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("This consumer is stopped during polling an exchange, so putting it back on the seda queue: " + exchange));
            }
            try {
                queue.put(exchange);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
            }
        }
    }

    protected void sendToConsumers(Exchange exchange) throws Exception {
        int size = this.endpoint.getConsumers().size();
        if (size > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Multicasting to " + this.endpoint.getConsumers().size() + " consumers for Exchange: " + exchange));
            }
            MulticastProcessor mp = this.getMulticastProcessor();
            AsyncProcessorHelper.process(mp, exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                }
            });
        } else {
            AsyncProcessorHelper.process(this.processor, exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                }
            });
        }
    }

    protected synchronized MulticastProcessor getMulticastProcessor() {
        if (this.multicast == null) {
            int size = this.endpoint.getConsumers().size();
            ArrayList<Processor> processors = new ArrayList<Processor>(size);
            for (SedaConsumer consumer : this.endpoint.getConsumers()) {
                processors.add(consumer.getProcessor());
            }
            ExecutorService multicastExecutor = this.endpoint.getCamelContext().getExecutorServiceStrategy().newFixedThreadPool(this, this.endpoint.getEndpointUri() + "(multicast)", size);
            this.multicast = new MulticastProcessor(this.endpoint.getCamelContext(), processors, null, true, multicastExecutor, false, false);
        }
        return this.multicast;
    }

    protected void doStart() throws Exception {
        int poolSize = this.endpoint.getConcurrentConsumers();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceStrategy().newFixedThreadPool(this, this.endpoint.getEndpointUri(), poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.executor.execute(this);
        }
        this.endpoint.onStarted(this);
    }

    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        this.endpoint.getCamelContext().getExecutorServiceStrategy().shutdownNow(this.executor);
        this.executor = null;
        if (this.multicast != null) {
            ServiceHelper.stopServices(this.multicast);
        }
    }
}

