/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */


package org.jfree.data.hc;

import org.jfree.data.xy.MatrixSeries;

/**
 * A class representing a heatmap of a {@link HCDataset}.
 * @author  viski project
 */
public class HeatMap extends MatrixSeries {

    /** The rownames matrix. */
    private String[] rowNames;
    /** The columnnames matrix. */
    private String[] columnNames;


    /**
     * Creates a new heatmap matrix.
     *
     * @param name  the name of the heatmap.
     * @param rows  the amount of rows.
     * @param columns  the amount of columns.
     */
    public HeatMap(String name, int rows, int columns) {

	super(name, rows, columns);

	int i;

	this.rowNames = new String[rows];
	this.columnNames = new String[columns];
	for (i = 0; i < rows; i++) this.rowNames[i] = "";
	for (i = 0; i < columns; i++) this.columnNames[i] = "";

    }

    /**
     * Returns the names of all rows.
     *
     * @return  The names of the rows..
     */
    public String[] getRowNames() {

	return this.rowNames;
    }

    /**
     * Returns the names of all columns.
     *
     * @return  The names of the columns.
     */
    public String[] getColumnNames() {

	return this.columnNames;
    }

    /**
     * Sets the name of a row.
     *
     * @param row  the row to be named.
     * @param name  the name.
     */
    public void setRowName(int row, String name) {

	this.rowNames[row] = name;
    }

    /**
     * Returns the name of a row.
     *
     * @param row  the row.
     *
     * @return  The name of this row.
     */
    public String getRowName(int row) {

	return this.rowNames[row];
    }

    /**
     * Sets the name of a column.
     *
     * @param column  the column to be named.
     * @param name  the name.
     */
    public void setColumnName(int column, String name) {

	this.columnNames[column] = name;
    }

    /** 
     * Returns the name of a column.
     *
     * @param column  the column.
     *
     * @return The name.  
     */
    public String getColumnName(int column) {

	return this.columnNames[column];
    }
}
