/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class RandomAccessLineReader {
    public static final int HTTP_BUFFER_SIZE = 4096;
    private long position = -1L;
    private String buffer;
    private ChunkDataSource chunkDataSource;

    public RandomAccessLineReader(URL url) throws FileNotFoundException, URISyntaxException {
        this.chunkDataSource = new ChunkDataSource(url, null);
    }

    public RandomAccessLineReader(URL url, BedLineParser bedLineParser, File outputFile, ChromosomeNormaliser chromosomeNormaliser) {
    }

    public boolean setPosition(long position) throws IOException, GBrowserException {
        if (position < 0L || position > this.length() - 1L) {
            position = -1L;
            return false;
        }
        this.buffer = this.buffer != null && position >= this.position && position < this.position + (long)this.buffer.length() ? this.buffer.substring((int)(position - this.position)) : null;
        this.position = position;
        return true;
    }

    public String readLine() throws IOException {
        if (this.buffer == null) {
            this.fillBuffer();
        }
        int indexOfNewLine = this.buffer.indexOf("\n");
        while (indexOfNewLine < 0 && this.position + (long)this.buffer.length() < this.length()) {
            this.fillBuffer();
            indexOfNewLine = this.buffer.indexOf("\n");
        }
        if (indexOfNewLine < 0) {
            return null;
        }
        String line = this.buffer.substring(0, indexOfNewLine);
        this.buffer = this.buffer.substring(indexOfNewLine + 1);
        this.position += (long)(indexOfNewLine + 1);
        return line;
    }

    private void fillBuffer() throws IOException {
        byte[] bytes = new byte[4096];
        if (this.buffer == null) {
            this.buffer = "";
        }
        long refillPosition = this.position + (long)this.buffer.length();
        this.chunkDataSource.read(refillPosition, bytes, false);
        this.buffer = this.buffer + new String(bytes);
    }

    public void close() {
        if (this.chunkDataSource != null) {
            this.chunkDataSource.close();
            this.chunkDataSource = null;
        }
    }

    public long length() throws IOException {
        return this.chunkDataSource.length();
    }
}

