/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutComponent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutContainer;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.QualityCoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackContext;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ScrollGroup
implements LayoutComponent,
LayoutContainer {
    public List<TrackGroup> trackGroups = new LinkedList<TrackGroup>();
    private int layoutHeight;
    private String name;
    private boolean scrollEnabled = false;
    private BufferedImage drawBuffer;
    private long time = 0L;

    public ScrollGroup(String name) {
        this.name = name;
    }

    public ScrollGroup() {
    }

    public ScrollGroup(String name, boolean scrollEnabled) {
        this(name);
        this.scrollEnabled = scrollEnabled;
    }

    public void draw(Graphics2D g, Rectangle plotArea, Rectangle scrollGroupViewPort, GBrowserView view) {
        LinkedList<Track> visibleTracks = new LinkedList<Track>();
        LinkedList<Collection<Drawable>> drawableLists = new LinkedList<Collection<Drawable>>();
        for (TrackGroup group : this.getTrackGroups()) {
            Iterator<Track> trackIter = group.getTracks().iterator();
            Iterator drawableIter = null;
            if (!group.isVisible()) continue;
            this.printTime(null);
            while (trackIter.hasNext()) {
                Track track;
                if (drawableIter != null && drawableIter.hasNext() || !(track = trackIter.next()).isVisible()) continue;
                Collection<Drawable> drawables = track.getDrawables();
                track.setFullHeight(drawables);
                drawableLists.add(drawables);
                visibleTracks.add(track);
                this.printTime(track.getName() + "\tgetDrawables\t");
            }
        }
        int drawBufferWidth = (int)scrollGroupViewPort.getWidth();
        int drawBufferHeight = this.getFullHeight();
        if (drawBufferHeight > 0) {
            if (this.drawBuffer == null || this.drawBuffer.getWidth() != drawBufferWidth || this.drawBuffer.getHeight() != drawBufferHeight) {
                this.drawBuffer = new BufferedImage(drawBufferWidth, drawBufferHeight, 2);
            }
            Graphics2D bufG2 = (Graphics2D)this.drawBuffer.getGraphics();
            bufG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            bufG2.setPaint(Color.white);
            bufG2.fillRect(0, 0, this.drawBuffer.getWidth(), this.drawBuffer.getHeight());
            int y = 0;
            int x = 0;
            Iterator drawableListIter = drawableLists.iterator();
            Iterator trackIter = visibleTracks.iterator();
            this.printTime(null);
            while (drawableListIter.hasNext() && trackIter.hasNext()) {
                Collection drawables = (Collection)drawableListIter.next();
                Track track = (Track)trackIter.next();
                y += track.getFullHeight();
                for (Drawable drawable : drawables) {
                    if (drawable == null) continue;
                    boolean expandDrawables = track.canExpandDrawables();
                    TrackContext trackContext = null;
                    if (expandDrawables && (track instanceof CoverageTrack || track instanceof QualityCoverageTrack)) {
                        trackContext = view.parentPlot.getReadScale() == GBrowserPlot.ReadScale.AUTO ? new TrackContext(track) : new TrackContext(track, track.getHeight() - view.parentPlot.getReadScale().numReads);
                    }
                    if (expandDrawables) {
                        drawable.expand(trackContext);
                    }
                    int maybeReversedY = y;
                    if (track.isReversed()) {
                        maybeReversedY -= track.getFullHeight();
                    } else {
                        drawable.upsideDown();
                    }
                    view.drawDrawable(bufG2, x, maybeReversedY, drawable);
                }
                this.printTime(track.getName() + "\tdrawDrawables");
            }
        }
        view.parentPlot.chartPanel.setScrollGroupBoundaries(this);
        int scrollValue = view.parentPlot.chartPanel.getScrollValue(this);
        int width = scrollGroupViewPort.width;
        int viewPortHeight = scrollGroupViewPort.height;
        g.drawImage(this.drawBuffer, (int)scrollGroupViewPort.getX(), (int)scrollGroupViewPort.getY(), (int)(scrollGroupViewPort.getX() + (double)width), (int)(scrollGroupViewPort.getY() + (double)viewPortHeight), 0, scrollValue, width, scrollValue + viewPortHeight, null);
    }

    private void printTime(String operation) {
        if (operation == null) {
            this.time = System.currentTimeMillis();
        } else {
            long elapsed = System.currentTimeMillis() - this.time;
            this.time = System.currentTimeMillis();
            if (elapsed > 1L) {
                // empty if block
            }
        }
    }

    @Override
    public int getHeight() {
        int canvasHeight = LayoutTool.getHeight(this, this.layoutHeight);
        if (this.scrollEnabled && this.layoutHeight != 0) {
            return Math.min(this.layoutHeight, canvasHeight);
        }
        return canvasHeight;
    }

    @Override
    public void setHeight(int height) {
        this.layoutHeight = height;
    }

    @Override
    public int getMinHeight() {
        if (this.scrollEnabled) {
            return 0;
        }
        return LayoutTool.getMinHeightSum(this);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void addTrack(Track track) {
        this.trackGroups.add(new TrackGroup(track));
    }

    public void addTrackGroup(TrackGroup group) {
        this.trackGroups.add(group);
    }

    public Collection<TrackGroup> getTrackGroups() {
        return this.trackGroups;
    }

    @Override
    public Collection<? extends LayoutComponent> getLayoutComponents() {
        return this.getTrackGroups();
    }

    public String toString() {
        return ScrollGroup.class + " " + this.name;
    }

    public boolean isScrollEnabled() {
        return this.scrollEnabled;
    }

    @Override
    public int getFullHeight() {
        return LayoutTool.getFullHeight(this);
    }

    public int getScrollReferenceY() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        if (this.scrollEnabled) {
            return LayoutTool.LayoutMode.FILL;
        }
        return LayoutTool.inferLayoutMode(this);
    }

    @Override
    public void setLayoutMode(LayoutTool.LayoutMode mode) {
    }

    @Override
    public void setDefaultLayoutMode() {
    }

    public void setScrollEnabled(boolean enabled) {
        this.scrollEnabled = enabled;
    }
}

