/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.Processor;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.SamplingThrottler;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="sample")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SamplingDefinition
extends OutputDefinition<SamplingDefinition> {
    @XmlAttribute
    private Long samplePeriod = 1L;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit units = TimeUnit.SECONDS;

    public SamplingDefinition() {
    }

    public SamplingDefinition(long samplePeriod, TimeUnit units) {
        this.samplePeriod = samplePeriod;
        this.units = units;
    }

    public String toString() {
        return "Sample[1 Exchange per " + this.samplePeriod + " " + this.units.toString().toLowerCase() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "sample";
    }

    @Override
    public String getLabel() {
        return "sample[1 Exchange per " + this.samplePeriod + " " + this.units.toString().toLowerCase() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        return new SamplingThrottler(childProcessor, this.samplePeriod, this.units);
    }

    public SamplingDefinition samplePeriod(long samplePeriod) {
        this.setSamplePeriod(samplePeriod);
        return this;
    }

    public SamplingDefinition timeUnits(TimeUnit units) {
        this.setUnits(units);
        return this;
    }

    public long getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(long samplePeriod) {
        this.samplePeriod = samplePeriod;
    }

    public void setUnits(String units) {
        this.units = TimeUnit.valueOf(units);
    }

    public void setUnits(TimeUnit units) {
        this.units = units;
    }
}

