/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.activemq.store.jdbc.DefaultDatabaseLocker;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactDatabaseLocker
extends DefaultDatabaseLocker {
    private static final Log LOG = LogFactory.getLog(TransactDatabaseLocker.class);

    public TransactDatabaseLocker() {
    }

    public TransactDatabaseLocker(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        this.setPersistenceAdapter(persistenceAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.stopping = false;
        LOG.info((Object)"Attempting to acquire the exclusive lock to become the Master broker");
        Statement statement = null;
        while (true) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                String sql = this.statements.getLockCreateStatement();
                statement = this.connection.prepareStatement(sql);
                if (statement.getMetaData() != null) {
                    ResultSet rs = statement.executeQuery();
                    rs.next();
                    break;
                }
                statement.execute();
                break;
            }
            catch (Exception e) {
                if (this.stopping) {
                    throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                }
                if (this.exceptionHandler != null) {
                    try {
                        this.exceptionHandler.handle(e);
                    }
                    catch (Throwable handlerException) {
                        LOG.error((Object)("The exception handler " + this.exceptionHandler.getClass().getCanonicalName() + " threw this exception: " + handlerException + " while trying to handle this excpetion: " + e), handlerException);
                    }
                } else {
                    LOG.error((Object)("Failed to acquire lock: " + e), (Throwable)e);
                }
            }
            finally {
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e1) {
                        LOG.warn((Object)("Caught while closing statement: " + e1), (Throwable)e1);
                    }
                    statement = null;
                }
            }
            LOG.debug((Object)("Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again to get the lock..."));
            try {
                Thread.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Master lock retry sleep interrupted", (Throwable)ie);
            }
        }
        LOG.info((Object)("Becoming the master on dataSource: " + this.dataSource));
    }
}

