/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestTokenRewriteStream
extends BaseTest {
    public void testInsertBeforeIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"0");
        String string = tokenRewriteStream.toString();
        String string2 = "0abc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testInsertAfterLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertAfter(2, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "abcx";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void test2InsertBeforeAfterMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.insertAfter(1, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "axbxc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "xbc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "abx";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "axc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void test2ReplaceMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, (Object)"x");
        tokenRewriteStream.replace(1, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "ayc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThenDeleteMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, (Object)"x");
        tokenRewriteStream.delete(1);
        String string = tokenRewriteStream.toString();
        String string2 = "ac";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThenInsertSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, (Object)"x");
        tokenRewriteStream.insertBefore(0, (Object)"0");
        String string = tokenRewriteStream.toString();
        String string2 = "0xbc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThen2InsertSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, (Object)"x");
        tokenRewriteStream.insertBefore(0, (Object)"y");
        tokenRewriteStream.insertBefore(0, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "zyxbc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testInsertThenReplaceSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"0");
        tokenRewriteStream.replace(0, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "0xbc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void test2InsertMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.insertBefore(1, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "ayxbc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void test2InsertThenReplaceIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"x");
        tokenRewriteStream.insertBefore(0, (Object)"y");
        tokenRewriteStream.replace(0, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "yxzbc";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThenInsertBeforeLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, (Object)"x");
        tokenRewriteStream.insertBefore(2, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abyx";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testInsertThenReplaceLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(2, (Object)"y");
        tokenRewriteStream.replace(2, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "abyx";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThenInsertAfterLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, (Object)"x");
        tokenRewriteStream.insertAfter(2, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxy";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceRangeThenInsertInMiddle() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertBefore(3, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxba";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceRangeThenInsertAtLeftEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertBefore(2, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abyxba";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceRangeThenInsertAtRightEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertBefore(4, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxba";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceRangeThenInsertAfterRightEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertAfter(4, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxyba";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceAll() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, 6, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "x";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceSubsetThenFetch() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"xyz");
        String string = tokenRewriteStream.toString(0, 6);
        String string2 = "abxyzba";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThenReplaceSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"xyz");
        tokenRewriteStream.replace(2, 5, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "abfooa";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceThenReplaceLowerIndexedSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"xyz");
        tokenRewriteStream.replace(1, 3, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "afoocba";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }

    public void testReplaceSingleMiddleThenOverlappingSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 2, (Object)"xyz");
        tokenRewriteStream.replace(0, 3, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "fooa";
        TestTokenRewriteStream.assertEquals((String)string, (String)string2);
    }
}

