/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description.vvsadl;

import fi.csc.microarray.description.GenericInputTypes;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.description.vvsadl.Deseparator;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.util.AdvancedStringTokenizer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class CompatibilityVVSADLParser {
    private static final Logger logger = Logger.getLogger(CompatibilityVVSADLParser.class);
    private String unitName;
    private HashMap<String, SADLSyntax.InputType> inputTypeMap = new HashMap();

    public static String generateOperationIdentifier(String category, String name) {
        return "\"" + category + "\"/\"" + name + "\"";
    }

    public CompatibilityVVSADLParser() {
        this(null);
    }

    public CompatibilityVVSADLParser(String filename) {
        this.unitName = filename;
        this.addInputType(GenericInputTypes.GENERIC);
        this.addInputType(ChipsterInputTypes.AFFY);
        this.addInputType(ChipsterInputTypes.CDNA);
        this.addInputType(ChipsterInputTypes.GENE_EXPRS);
        this.addInputType(ChipsterInputTypes.GENELIST);
        this.addInputType(ChipsterInputTypes.PHENODATA);
    }

    public SADLDescription parse(String vvsadlString) throws SADLParser.ParseException {
        AdvancedStringTokenizer tokens = this.getTokenizer(vvsadlString);
        return this.parseAnalysis(tokens);
    }

    public List<SADLDescription> parseMultiple(String vvsadlString) throws SADLParser.ParseException {
        LinkedList<SADLDescription> descriptions = new LinkedList<SADLDescription>();
        AdvancedStringTokenizer tokens = this.getTokenizer(vvsadlString);
        boolean parsingPreviousSuccessful = true;
        while (tokens.hasNext()) {
            try {
                descriptions.add(this.parseAnalysis(tokens));
                parsingPreviousSuccessful = true;
            }
            catch (SADLParser.ParseException pe) {
                if (parsingPreviousSuccessful) {
                    descriptions.removeLast();
                    logger.error((Object)"Could not parse description. ", (Throwable)pe);
                }
                parsingPreviousSuccessful = false;
            }
        }
        return descriptions;
    }

    public void addInputType(SADLSyntax.InputType type) {
        this.inputTypeMap.put(type.getName(), type);
    }

    private SADLDescription parseAnalysis(AdvancedStringTokenizer tokens) throws SADLParser.ParseException {
        if (!"ANALYSIS".equals(tokens.next())) {
            throw new SADLParser.ParseException("VVSADL should start with \"ANALYSIS\", not " + tokens.current(), this.unitName);
        }
        String packageName = tokens.next();
        String name = tokens.next();
        if (this.unitName == null) {
            this.unitName = packageName + " / " + name;
        }
        String comment = this.readComment(tokens);
        SADLDescription description = new SADLDescription(SADLDescription.Name.createName(name), comment);
        if (tokens.hasNext() && "INPUT".equals(tokens.peek())) {
            tokens.next();
            List<SADLDescription.Input> inputs = this.parseInputs(tokens, description);
            description.addInputs(inputs);
        }
        if (tokens.hasNext() && "OUTPUT".equals(tokens.peek())) {
            tokens.next();
            List<SADLDescription.Output> outputs = this.parseOutputs(tokens, description);
            description.addOutputs(outputs);
        }
        while (tokens.hasNext() && "PARAMETER".equals(tokens.peek())) {
            SADLDescription.Parameter parameter = this.parseParameter(tokens);
            description.addParameter(parameter);
        }
        return description;
    }

    private List<SADLDescription.Output> parseOutputs(AdvancedStringTokenizer tokens, SADLDescription description) {
        LinkedList<SADLDescription.Output> outputList = new LinkedList<SADLDescription.Output>();
        Deseparator outputs = new Deseparator(",", tokens, 1);
        for (String[] output : outputs) {
            outputList.add(new SADLDescription.Output(SADLDescription.Name.createName(output[0])));
        }
        return outputList;
    }

    private List<SADLDescription.Input> parseInputs(AdvancedStringTokenizer tokens, SADLDescription description) throws SADLParser.ParseException {
        LinkedList<SADLDescription.Input> inputList = new LinkedList<SADLDescription.Input>();
        Deseparator inputs = new Deseparator(",", tokens, 2);
        for (String[] input : inputs) {
            SADLDescription.Input newInput;
            if (input[1].contains("[...]")) {
                String filePattern = input[1];
                String prefix = filePattern.substring(0, filePattern.indexOf("[...]"));
                String postfix = filePattern.substring(filePattern.indexOf("[...]") + "[...]".length());
                newInput = new SADLDescription.Input(this.inputTypeMap.get(input[0]), SADLDescription.Name.createNameSet(prefix, postfix));
            } else {
                newInput = new SADLDescription.Input(this.inputTypeMap.get(input[0]), SADLDescription.Name.createName(input[1]));
            }
            if (newInput.getType() == null) {
                throw new SADLParser.ParseException("Invalid input type: " + input[0], description.getName().getID());
            }
            inputList.add(newInput);
        }
        return inputList;
    }

    private SADLDescription.Parameter parseParameter(AdvancedStringTokenizer tokens) throws SADLParser.ParseException {
        if (!"PARAMETER".equals(tokens.next())) {
            throw new SADLParser.ParseException("VVSADL param line should start with \"PARAMETER\", not " + tokens.current(), this.unitName);
        }
        String name = tokens.next();
        SADLSyntax.ParameterType type = null;
        SADLDescription.Name[] options = null;
        if (tokens.peek().startsWith("[")) {
            options = this.readSelectionType(tokens);
            type = SADLSyntax.ParameterType.ENUM;
        } else {
            type = SADLSyntax.ParameterType.valueOf(tokens.next());
        }
        String from = null;
        String to = null;
        String defaultValue = null;
        if ("FROM".equals(tokens.peek())) {
            tokens.next();
            from = tokens.next();
        }
        if ("TO".equals(tokens.peek())) {
            tokens.next();
            to = tokens.next();
        }
        if ("DEFAULT".equals(tokens.peek())) {
            tokens.next();
            defaultValue = tokens.next();
        }
        String comment = this.readComment(tokens);
        SADLDescription.Parameter parameter = new SADLDescription.Parameter(SADLDescription.Name.createName(name), type, options, from, to, defaultValue, comment);
        return parameter;
    }

    private String readComment(AdvancedStringTokenizer tokens) throws SADLParser.ParseException {
        String comment = null;
        try {
            comment = tokens.next().substring(1);
            if (comment.contains(")")) {
                return "";
            }
            while (tokens.hasNext() && !tokens.peek().contains(")")) {
                comment = comment + " " + tokens.next();
            }
            String lastToken = tokens.next();
            comment = comment + " " + lastToken.substring(0, lastToken.length() - 1);
            return comment;
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)("on exception comment was: " + comment));
            throw new SADLParser.ParseException("comment start or end missing", this.unitName);
        }
    }

    private SADLDescription.Name[] readSelectionType(AdvancedStringTokenizer tokens) {
        String s = "";
        while (!(s = s + tokens.next()).endsWith("]")) {
        }
        s = s.substring(1, s.length() - 1);
        AdvancedStringTokenizer options = new AdvancedStringTokenizer(s, true, false, ",");
        LinkedList<SADLDescription.Name> list = new LinkedList<SADLDescription.Name>();
        while (options.hasNext()) {
            list.add(SADLDescription.Name.createName(options.next()));
        }
        return list.toArray(new SADLDescription.Name[0]);
    }

    private AdvancedStringTokenizer getTokenizer(String vvsadlString) {
        return new AdvancedStringTokenizer(vvsadlString, false, true, " \t\n\r\f/");
    }
}

