/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.EmptyTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSNPTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RepeatMaskerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TranscriptTrack;
import java.awt.Color;
import java.util.LinkedList;

public class GeneTrackGroup
extends TrackGroup {
    protected TranscriptTrack transcript;
    protected Track geneOverview;
    protected Track gene;
    protected ReferenceSNPTrack snpTrack = null;
    protected RepeatMaskerTrack repeatMasker;
    protected Track geneOverviewReversed;
    protected Track geneReversed;
    protected TranscriptTrack transcriptReversed;
    protected ReferenceSNPTrack snpTrackReversed;

    public GeneTrackGroup(GBrowserView dataView, AreaRequestHandler annotationDataSource, AreaRequestHandler repeatDataSource, boolean isUserData) {
        super(dataView);
        if (annotationDataSource != null) {
            this.transcript = new TranscriptTrack(GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcript.setView(dataView);
            this.transcript.setAreaRequestHandler(annotationDataSource);
            this.transcript.setStrand(Strand.FORWARD);
            this.geneOverview = new EmptyTrack(this.transcript.getMinHeight(), 10000000L);
            this.geneOverview.setView(dataView);
            this.gene = new GeneTrack(GBrowserConstants.COLOR_BLUE_BRIGHTER, GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.gene.setView(dataView);
            this.gene.setAreaRequestHandler(annotationDataSource);
            this.gene.setStrand(Strand.FORWARD);
        }
        if (repeatDataSource != null) {
            this.repeatMasker = new RepeatMaskerTrack(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.repeatMasker.setView(dataView);
            this.repeatMasker.setAreaRequestHandler(repeatDataSource);
        }
        if (annotationDataSource != null) {
            this.geneOverviewReversed = new EmptyTrack(this.transcript.getMinHeight(), 10000000L);
            this.geneOverviewReversed.setView(dataView);
            this.geneReversed = new GeneTrack(GBrowserConstants.COLOR_BLUE_BRIGHTER, GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.geneReversed.setView(dataView);
            this.geneReversed.setAreaRequestHandler(annotationDataSource);
            this.geneReversed.setStrand(Strand.REVERSE);
            this.transcriptReversed = new TranscriptTrack(GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcriptReversed.setView(dataView);
            this.transcriptReversed.setAreaRequestHandler(annotationDataSource);
            this.transcriptReversed.setStrand(Strand.REVERSE);
        }
        this.adds(isUserData);
    }

    public void adds(boolean isUserData) {
        this.tracks = new LinkedList();
        if (!isUserData) {
            TitleTrack title = new TitleTrack("Annotations", Color.black);
            title.setView(this.view);
            this.tracks.add(title);
        }
        if (this.transcript != null) {
            this.tracks.add(this.transcript);
            this.tracks.add(this.geneOverview);
            this.tracks.add(this.gene);
        }
        if (this.snpTrack != null) {
            this.tracks.add(this.snpTrack);
        }
        if (isUserData) {
            SeparatorTrack separator = new SeparatorTrack(Color.gray, 1, 0L, Long.MAX_VALUE);
            separator.setView(this.view);
            this.tracks.add(separator);
        } else {
            RulerTrack ruler = new RulerTrack();
            ruler.setView(this.view);
            this.tracks.add(ruler);
        }
        if (this.snpTrackReversed != null) {
            this.tracks.add(this.snpTrackReversed);
        }
        if (this.repeatMasker != null) {
            this.tracks.add(this.repeatMasker);
        }
        if (this.transcript != null) {
            this.tracks.add(this.geneOverviewReversed);
            this.tracks.add(this.geneReversed);
            this.tracks.add(this.transcriptReversed);
        }
    }

    @Override
    public String getName() {
        return "GeneTrackGroup";
    }

    private void setChangeSNP(boolean change) {
        if (change) {
            this.snpTrack.changeSNPView();
            this.snpTrackReversed.changeSNPView();
        } else {
            this.snpTrack.returnSNPView();
            this.snpTrackReversed.returnSNPView();
        }
        this.view.fireAreaRequests();
        this.view.redraw();
    }

    @Override
    public void showOrHide(String name, boolean state) {
        super.showOrHide(name, state);
        if (this.snpTrack != null && name.equals("changeSNP")) {
            this.setChangeSNP(state);
        }
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return LayoutTool.LayoutMode.FIXED;
    }

    @Override
    public int getHeight() {
        return 250;
    }
}

