/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HorizontalView
extends GBrowserView
implements KeyListener {
    private Timer keyTimer;
    private Set<Integer> keySet = new HashSet<Integer>();
    private Map<Rectangle, Drawable> drawableMap = new HashMap<Rectangle, Drawable>();
    private Shape clip;

    public HorizontalView(GBrowserPlot parent, boolean movable, boolean zoomable, boolean selectable) {
        super(parent, movable, zoomable, selectable);
        parent.chartPanel.addKeyListener(this);
    }

    @Override
    public void draw(Graphics2D g, Rectangle viewPort, Rectangle viewCanvasArea) {
        this.drawableMap.clear();
        this.clip = g.getClip();
        super.draw(g, viewPort, viewCanvasArea);
        if (this.highlight != null) {
            Rectangle rect = g.getClip().getBounds();
            rect.x = this.bpToTrack(this.highlight.start);
            rect.width = Math.max(3, this.bpToTrack(this.highlight.end) - rect.x);
            rect.height = 20;
            g.setPaint(new Color(0, 0, 0, 64));
            g.fill(rect);
            g.setPaint(new Color(0, 0, 0, 255));
            g.draw(rect);
        }
    }

    @Override
    protected void drawDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        g.setPaint(drawable.color);
        if (drawable instanceof TextDrawable) {
            this.drawTextDrawable(g, x, y, drawable);
        } else if (drawable instanceof RectDrawable) {
            this.drawRectDrawable(g, x, y, drawable);
        } else if (drawable instanceof LineDrawable) {
            this.drawLineDrawable(g, x, y, drawable);
        }
    }

    protected void drawTextDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        g.setFont(g.getFont().deriveFont(10.0f));
        TextDrawable text = (TextDrawable)drawable;
        g.drawString(text.text, text.x + x, text.y + y);
    }

    protected void drawRectDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        String tooltipText;
        RectDrawable rect = (RectDrawable)drawable;
        if (rect.color != null) {
            g.setPaint(rect.color);
            g.fillRect(rect.x + x + 1, rect.y + y + 1, rect.width, rect.height);
        }
        if (rect.lineColor != null) {
            g.setPaint(rect.lineColor);
            g.drawRect(rect.x + x + 1, rect.y + y + 1, rect.width - 1, rect.height - 1);
        }
        if ((tooltipText = drawable.getTooltipText()) != null) {
            try {
                this.drawableMap.put(new Rectangle(rect.x + x + this.clip.getBounds().x, rect.y + y + this.clip.getBounds().y, rect.width, rect.height), drawable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void drawLineDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        LineDrawable line = (LineDrawable)drawable;
        g.drawLine(line.x + x, line.y + y, line.x2 + x, line.y2 + y);
    }

    @Override
    protected void handleDrag(Point2D start, Point2D end, boolean disableDrawing) {
        double bpMove = this.trackToBp(start.getX()).minus(this.trackToBp(end.getX()));
        RegionDouble newRegion = this.bpRegion.clone();
        newRegion.move(bpMove);
        this.setBpRegion(newRegion, disableDrawing);
        if (!disableDrawing) {
            this.parentPlot.redraw();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((this.zoomable || this.movable) && this.isNavigationKey(e.getKeyCode())) {
            this.keySet.add(e.getKeyCode());
            this.startKeyAnimation();
        }
    }

    public boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == 37 || keyCode == 39;
    }

    public void startKeyAnimation() {
        if (this.keyTimer == null) {
            this.stopKeyAnimation();
            this.keyTimer = new Timer(33, new ActionListener(){
                private int i = 0;
                private long startTime = System.currentTimeMillis();

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean skipFrame = true;
                            boolean firstNotSkipped = true;
                            while (skipFrame || firstNotSkipped) {
                                if (!skipFrame) {
                                    firstNotSkipped = false;
                                }
                                if (HorizontalView.this.keySet.isEmpty() || !HorizontalView.this.parentPlot.chartPanel.hasFocus()) {
                                    HorizontalView.this.stopKeyAnimation();
                                    break;
                                }
                                if (HorizontalView.this.zoomable) {
                                    double ZOOM_FACTOR = 0.78;
                                    if (HorizontalView.this.keySet.contains(38)) {
                                        HorizontalView.this.zoom(HorizontalView.this.getWidth() / 2, -0.78, skipFrame);
                                    }
                                    if (HorizontalView.this.keySet.contains(40)) {
                                        HorizontalView.this.zoom(HorizontalView.this.getWidth() / 2, 0.78, skipFrame);
                                    }
                                }
                                if (HorizontalView.this.movable) {
                                    double SPEED_DIVIDER = 50.0;
                                    if (HorizontalView.this.keySet.contains(37)) {
                                        HorizontalView.this.bpRegion.move((double)(-HorizontalView.this.getBpRegion().getLength().longValue()) / 50.0);
                                        HorizontalView.this.setBpRegion(HorizontalView.this.bpRegion, skipFrame);
                                    }
                                    if (HorizontalView.this.keySet.contains(39)) {
                                        HorizontalView.this.bpRegion.move((double)HorizontalView.this.getBpRegion().getLength().longValue() / 50.0);
                                        HorizontalView.this.setBpRegion(HorizontalView.this.bpRegion, skipFrame);
                                        if (!skipFrame) {
                                            HorizontalView.this.parentPlot.redraw();
                                        }
                                    }
                                }
                                i++;
                                skipFrame = (double)System.currentTimeMillis() > (double)startTime + 33.333333333333336 * (double)i;
                            }
                        }
                    });
                }
            });
            this.keyTimer.setRepeats(true);
            this.keyTimer.setCoalesce(false);
            this.keyTimer.start();
        }
    }

    private void stopKeyAnimation() {
        if (this.keyTimer != null) {
            this.keyTimer.stop();
            this.keyTimer = null;
            this.parentPlot.redraw();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((this.zoomable || this.movable) && this.isNavigationKey(e.getKeyCode())) {
            this.keySet.remove(e.getKeyCode());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public String tooltipRequest(Point2D locationOnPanel) {
        for (Rectangle rect : this.drawableMap.keySet()) {
            if (!rect.contains(locationOnPanel)) continue;
            return this.drawableMap.get(rect).getTooltipText();
        }
        return null;
    }

    @Override
    public int getFullHeight() {
        return 0;
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return LayoutTool.inferLayoutMode(this);
    }

    @Override
    public void setLayoutMode(LayoutTool.LayoutMode mode) {
    }

    @Override
    public void setDefaultLayoutMode() {
    }
}

