/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.description.GenericInputTypes;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OperationDefinition
implements ExecutionItem {
    private static final Logger logger = Logger.getLogger(OperationDefinition.class);
    public static final String IMPORT_DEFINITION_ID = "operation-definition-id-import";
    public static final String CREATE_DEFINITION_ID = "operation-definition-id-user-modification";
    public static final OperationDefinition IMPORT_DEFINITION;
    public static final OperationDefinition CREATE_DEFINITION;
    public static String IDENTIFIER_SEPARATOR;
    private String id;
    private String displayName;
    private ToolCategory category;
    private LinkedList<Parameter> parameters = new LinkedList();
    private String description;
    private String helpURL;
    private int colorCount;
    private int outputCount = 0;
    private LinkedList<InputDefinition> inputs = new LinkedList();
    private Suitability evaluatedSuitability = null;
    private boolean hasSourceCode;

    public OperationDefinition(String id, String displayName, ToolCategory category, String description, boolean hasSourceCode, String helpURL) {
        this.id = id;
        this.displayName = displayName;
        this.category = category;
        this.hasSourceCode = hasSourceCode;
        this.helpURL = helpURL;
        if (category != null) {
            category.addOperation(this);
        }
        this.description = description;
    }

    public OperationDefinition(String id, String displayName, ToolCategory category, String description, boolean hasSourceCode) {
        this(id, displayName, category, description, hasSourceCode, null);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public ToolCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCategoryName() {
        return this.category.getName();
    }

    public String getFullName() {
        return this.getCategoryName() + " / " + this.getDisplayName();
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public Suitability evaluateSuitabilityFor(Iterable<DataBean> data, Suitability parameterSuitability) {
        this.bindInputs(data);
        if (this.evaluatedSuitability.isOk()) {
            this.evaluatedSuitability = parameterSuitability == null ? OperationDefinition.parameterSuitability(this.getParameters()) : parameterSuitability;
        }
        return this.getEvaluatedSuitability();
    }

    public static Suitability parameterSuitability(List<Parameter> params) {
        for (Parameter param : params) {
            if (param.isOptional() || param.getValue() != null && !param.getValue().equals("")) continue;
            return Suitability.EMPTY_REQUIRED_PARAMETERS;
        }
        return Suitability.SUITABLE;
    }

    public LinkedList<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameter(String id) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getID().equals(id)) continue;
            return parameter;
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void addInput(SADLDescription.Name name, String description, SADLSyntax.InputType type, boolean isOptional) {
        InputDefinition input = new InputDefinition(name, description, type, isOptional);
        this.inputs.add(input);
    }

    public void addInput(String prefix, String postfix, String displayName, String description, SADLSyntax.InputType type, boolean isOptional) {
        InputDefinition input = new InputDefinition(prefix, postfix, displayName, description, type, isOptional);
        this.inputs.add(input);
    }

    public List<InputDefinition> getInputs() {
        return this.inputs;
    }

    public InputDefinition getInput(String id) {
        for (InputDefinition input : this.inputs) {
            if (!input.idMatches(id)) continue;
            return input;
        }
        return null;
    }

    public LinkedList<Operation.DataBinding> bindInputs(Iterable<DataBean> inputValues) {
        LinkedList<Operation.DataBinding> bindings = new LinkedList<Operation.DataBinding>();
        LinkedList<DataBean> notProcessedInputValues = new LinkedList<DataBean>();
        for (DataBean bean : inputValues) {
            notProcessedInputValues.add(bean);
        }
        LinkedList<InputDefinition> unboundMetadataDefinitions = new LinkedList<InputDefinition>();
        logger.debug((Object)("binding " + notProcessedInputValues.size() + " values to " + this.inputs.size() + " formal inputs"));
        for (InputDefinition input : this.inputs) {
            input.resetMulti();
            boolean foundBinding = false;
            if (this.doBackwardsCompatibleMetadataCheck(input)) {
                foundBinding = true;
                unboundMetadataDefinitions.add(input);
                continue;
            }
            LinkedList<DataBean> removedValues = new LinkedList<DataBean>();
            for (DataBean value : notProcessedInputValues) {
                logger.debug((Object)("  trying to bind " + value.getName() + " to " + input.id + " (" + input.type + ")"));
                if (!this.doBackwardsCompatibleTypeCheck(input.type, value)) continue;
                logger.debug((Object)("    bound successfully (" + value.getName() + " -> " + input.getID() + ")"));
                bindings.add(new Operation.DataBinding(value, input.getID(), input.getType()));
                foundBinding = true;
                removedValues.add(value);
                if (!input.isMulti()) break;
                input.nextMulti();
            }
            notProcessedInputValues.removeAll(removedValues);
            if (foundBinding || input.isOptional()) continue;
            logger.debug((Object)("  no binding found for " + input.id));
            this.evaluatedSuitability = Suitability.NOT_ENOUGH_INPUTS;
            return null;
        }
        if (notProcessedInputValues.size() > 0) {
            logger.debug((Object)("  " + notProcessedInputValues.size() + " concrete inputs were not bound"));
            this.evaluatedSuitability = Suitability.TOO_MANY_INPUTS;
            return null;
        }
        logger.debug((Object)("we have " + bindings.size() + " bindings before metadata retrieval"));
        if (!unboundMetadataDefinitions.isEmpty()) {
            Iterator bindingIterator = bindings.iterator();
            LinkedList<Operation.DataBinding> phenodataBindings = new LinkedList<Operation.DataBinding>();
            for (InputDefinition unboundMetadata : unboundMetadataDefinitions) {
                DataBean input = ((Operation.DataBinding)bindingIterator.next()).getData();
                DataBean metadata = LinkUtils.retrieveInherited(input, DataBean.Link.ANNOTATION);
                if (metadata != null) {
                    phenodataBindings.add(new Operation.DataBinding(metadata, unboundMetadata.getID(), ChipsterInputTypes.PHENODATA));
                    continue;
                }
                this.evaluatedSuitability = Suitability.NOT_ENOUGH_INPUTS;
                return null;
            }
            bindings.addAll(phenodataBindings);
        }
        logger.debug((Object)("we have " + bindings.size() + " bindings after metadata retrieval"));
        this.evaluatedSuitability = Suitability.SUITABLE;
        return bindings;
    }

    private boolean doBackwardsCompatibleTypeCheck(SADLSyntax.InputType type, DataBean data) {
        if (type == ChipsterInputTypes.AFFY) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.RAW_AFFYMETRIX_EXPRESSION_VALUES);
        }
        if (type == ChipsterInputTypes.CDNA) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.RAW_EXPRESSION_VALUES);
        }
        if (type == ChipsterInputTypes.GENE_EXPRS) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.NORMALISED_EXPRESSION_VALUES);
        }
        if (type == ChipsterInputTypes.GENELIST) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.GENENAMES);
        }
        if (type == ChipsterInputTypes.BAM) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.BAM_FILE);
        }
        if (type == ChipsterInputTypes.FASTA) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.FASTA_FILE);
        }
        if (type == ChipsterInputTypes.GTF) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.GTF_FILE);
        }
        if (type == ChipsterInputTypes.PHENODATA) {
            return data.hasTypeTag(BasicModule.TypeTags.PHENODATA);
        }
        if (type == GenericInputTypes.GENERIC) {
            return true;
        }
        throw new IllegalArgumentException();
    }

    private boolean doBackwardsCompatibleMetadataCheck(InputDefinition input) {
        return input.id.startsWith("phenodata");
    }

    public Suitability getEvaluatedSuitability() {
        return this.evaluatedSuitability;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    public String toStringVerbose() {
        String s = "\n-------------- operation definition --------------\n";
        s = s + this.getCategoryName() + " / ";
        s = s + this.getDisplayName() + " ";
        s = s + "(" + this.getID() + ")\n";
        for (InputDefinition input : this.inputs) {
            String type = input.getType() != null ? input.getType().getName() : "null";
            s = s + input.getID() + " " + type + " " + input.getDescription() + "\n";
        }
        for (Parameter parameter : this.parameters) {
            String value = parameter.getValue() == null ? "[no default value]" : parameter.getValueAsString();
            s = s + parameter.getID() + " " + value + "\n";
        }
        s = s + "\n-------------- operation definition --------------\n";
        return s;
    }

    static {
        IDENTIFIER_SEPARATOR = "/";
        IMPORT_DEFINITION = new OperationDefinition(IMPORT_DEFINITION_ID, "Import data", ToolCategory.IMPORT_CATEGORY, "Import data.", false, null);
        CREATE_DEFINITION = new OperationDefinition(CREATE_DEFINITION_ID, "Create a dataset", ToolCategory.CREATE_CATEGORY, "Create a new dataset.", false, null);
    }

    public static class InputDefinition {
        private String id;
        private String displayName;
        private String description = null;
        private String postfix = null;
        private boolean isMulti = false;
        private int multiCounter;
        private SADLSyntax.InputType type;
        private boolean isOptional;

        public InputDefinition(SADLDescription.Name name, String description, SADLSyntax.InputType type, boolean isOptional) {
            this.resetMulti();
            this.id = name.getID();
            this.displayName = name.getDisplayName();
            this.description = description;
            this.type = type;
            this.isOptional = isOptional;
        }

        public InputDefinition(String prefix, String postfix, String displayName, String description, SADLSyntax.InputType type, boolean isOptional) {
            this.id = prefix;
            this.postfix = postfix;
            this.displayName = displayName;
            this.description = description;
            this.type = type;
            this.isOptional = isOptional;
            this.isMulti = true;
        }

        public String getID() {
            if (!this.isMulti) {
                return this.id;
            }
            return this.id + Strings.toString(this.multiCounter, 3) + this.postfix;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDisplayName(String id) {
            if (!this.isMulti()) {
                return this.displayName;
            }
            if (!this.idMatches(id)) {
                return this.displayName;
            }
            String middle = id.substring(this.id.length(), id.lastIndexOf(this.postfix));
            return this.displayName.replaceAll("\\{\\.\\.\\.\\}", middle);
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public SADLSyntax.InputType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        private void nextMulti() {
            ++this.multiCounter;
        }

        public boolean isMulti() {
            return this.isMulti;
        }

        public void resetMulti() {
            this.multiCounter = 1;
        }

        public boolean idMatches(String id) {
            String middle;
            if (!this.isMulti()) {
                return this.getID().equals(id);
            }
            return id.startsWith(this.id) && id.endsWith(this.postfix) && (middle = id.substring(this.id.length(), id.lastIndexOf(this.postfix))).matches("\\d+");
        }
    }

    public static enum Suitability {
        SUITABLE,
        IMPOSSIBLE,
        ALREADY_DONE,
        TOO_MANY_INPUTS,
        NOT_ENOUGH_INPUTS,
        EMPTY_REQUIRED_PARAMETERS;

        private static final Color GREEN;
        private static final Color YELLOW;
        private static final Color RED;
        private static final Color COLOR_ALREADY_DONE;

        public boolean isImpossible() {
            return this == IMPOSSIBLE || this == NOT_ENOUGH_INPUTS || this == TOO_MANY_INPUTS;
        }

        public boolean isOk() {
            return this == SUITABLE;
        }

        public Color getIndicatorColor() {
            if (this.isImpossible()) {
                return RED;
            }
            if (this.isOk()) {
                return GREEN;
            }
            if (this == ALREADY_DONE) {
                return COLOR_ALREADY_DONE;
            }
            return YELLOW;
        }

        public String toString() {
            switch (this) {
                case SUITABLE: {
                    return "Suitable";
                }
                case IMPOSSIBLE: {
                    return "Impossible";
                }
                case ALREADY_DONE: {
                    return "Already done";
                }
                case TOO_MANY_INPUTS: {
                    return "Too many inputs";
                }
                case NOT_ENOUGH_INPUTS: {
                    return "Not enough inputs";
                }
                case EMPTY_REQUIRED_PARAMETERS: {
                    return "Some required parameters are empty";
                }
            }
            throw new RuntimeException("unknown suitability: " + this.name());
        }

        static {
            GREEN = new Color(52, 196, 49);
            YELLOW = new Color(196, 186, 49);
            RED = new Color(196, 49, 49);
            COLOR_ALREADY_DONE = new Color(230, 180, 250);
        }
    }
}

