/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.SADLTool;
import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SADLDescriptionTest {
    public static void main(String[] args) throws Exception {
        SADLDescriptionTest test = new SADLDescriptionTest();
        test.testDescriptions();
        test.testSADLTool();
        System.out.println("SADLDescriptionTest OK");
    }

    @Test(groups={"unit"})
    private void testSADLTool() throws IOException {
        String rScript = "# TOOL \"BLAST\" / blastn.sadl: blastn (Heuristic tool to search hits for a nucleotide sequence from a nucleotode sequence database.)\n# INPUT query: \"Query sequence\" TYPE GENERIC\n# OUTPUT out.txt\n# PARAMETER OPTIONAL query_loc: \"Location on the query sequence\" TYPE STRING (Location of the search region on the query sequence. Format: start-stop, for example: 23-66.  Default: the whole query sequence)\n# PARAMETER OPTIONAL strand: \"Query strand\" TYPE [both: Both, minus: Minus, plus: Plus] DEFAULT both ( Query strand or strands to search against the database.  Default: both strands.)\n\necho('jee');\n";
        SADLTool tool = new SADLTool("#");
        SADLTool.ParsedScript parsedScript = tool.parseScript(new ByteArrayInputStream(rScript.getBytes()));
        String rScript2 = tool.toScriptString(parsedScript);
        Assert.assertEquals((String)rScript2, (String)rScript);
    }

    @Test(groups={"unit"})
    public void testDescriptions() throws Exception {
        DirectoryLayout.initialiseUnitTestLayout();
        LinkedList<String> resources = new LinkedList<String>();
        for (File file : new File("src/main/applications/wrapper/comp/conf").listFiles()) {
            if (!file.getName().endsWith("-module.xml")) continue;
            Document module = XmlUtil.parseFile(file);
            NodeList tools = module.getDocumentElement().getElementsByTagName("tool");
            for (int i = 0; i < tools.getLength(); ++i) {
                Element tool = (Element)tools.item(i);
                String resource = tool.getElementsByTagName("resource").item(0).getTextContent();
                if (resource.endsWith(".acd")) continue;
                resources.add(resource);
            }
        }
        for (String resource : resources) {
            try {
                String sadl = null;
                if (resource.split("\\.").length > 2) {
                    System.out.println("validating class " + resource);
                    JavaAnalysisJobBase jobBase = (JavaAnalysisJobBase)Class.forName(resource).newInstance();
                    sadl = jobBase.getSADL();
                } else {
                    File[] dirsContainingDescriptions = new File[]{new File("src/main/modules/chipster/bsh"), new File("src/main/modules/sequence/shell"), new File("src/main/modules/chipster/R-2.12"), new File("src/main/modules/ngs/R-2.12")};
                    LinkedList<File> potentialFiles = new LinkedList<File>();
                    for (File dir : dirsContainingDescriptions) {
                        for (File file : dir.listFiles()) {
                            potentialFiles.add(file);
                        }
                    }
                    for (File file : potentialFiles) {
                        if (!file.getName().endsWith(resource)) continue;
                        if (resource.endsWith(".R")) {
                            SADLTool.ParsedScript res = new SADLTool("#").parseScript(new FileInputStream(file));
                            sadl = res.SADL;
                        } else if (resource.endsWith(".bsh")) {
                            SADLTool.ParsedScript res = new SADLTool("//").parseScript(new FileInputStream(file));
                            sadl = res.SADL;
                        } else {
                            sadl = Files.fileToString(file);
                        }
                        System.out.println("validating file " + file.getCanonicalFile());
                        break;
                    }
                }
                if (sadl != null) {
                    new ChipsterSADLParser.Validator().validate(resource, sadl);
                    continue;
                }
                throw new RuntimeException("don't know what to do with: " + resource);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("when parsing " + resource + ": " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")"));
            }
        }
    }
}

