/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.messaging.JobState;
import java.io.File;

public class SortGtf
extends JavaAnalysisJobBase {
    public static final ChromosomeNormaliser CHROMOSOME_NORMALISER = new ChromosomeNormaliser(){

        @Override
        public String normaliseChromosome(String chromosomeName) {
            String SEPARATOR = ".";
            if (chromosomeName.contains(SEPARATOR)) {
                chromosomeName = chromosomeName.substring(0, chromosomeName.indexOf(SEPARATOR));
            }
            return chromosomeName;
        }
    };

    @Override
    public String getSADL() {
        return "TOOL SortGtf.java: \"Sort GTF\" (Sort a GTF file by chromosome and start position.)\nINPUT unsorted.gtf: \"GTF file\" TYPE GENERIC\nOUTPUT sorted.gtf: \"Sorted GTF file\"\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobWorkDir, this.analysis.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.analysis.getOutputFiles().get(0).getFileName().getID());
            new TsvSorter().sort(inputFile, outputFile, CHROMOSOME_NORMALISER, GtfLineParser.Column.SEQNAME.ordinal(), GtfLineParser.Column.START.ordinal(), new GtfLineParser());
        }
        catch (Exception e) {
            this.updateState(JobState.FAILED, e.getMessage());
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }
}

