/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.LocalTreeToolBar;
import org.emboss.jemboss.gui.filetree.RemoteFileTreePanel;
import org.emboss.jemboss.soap.JembossSoapException;

public class LocalAndRemoteFileTreeFrame
extends JFrame {
    private static DragTree ltree;
    private JMenuItem prefClose;

    public LocalAndRemoteFileTreeFrame(JembossParams jembossParams) throws JembossSoapException {
        super("File Manager");
        try {
            final JPanel jPanel = new JPanel(new BorderLayout());
            RemoteFileTreePanel remoteFileTreePanel = new RemoteFileTreePanel(jembossParams, false);
            ltree = new DragTree(new File(jembossParams.getUserHome()), this, jembossParams);
            final JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)new LocalTreeToolBar(jembossParams), "North");
            JScrollPane jScrollPane = new JScrollPane(ltree);
            final JSplitPane jSplitPane = new JSplitPane(0, jPanel2, jPanel);
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenu.setMnemonic(70);
            final Dimension dimension = new Dimension(210, 270);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Vertical Split");
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jSplitPane.remove(jPanel);
                    jSplitPane.remove(jPanel2);
                    jSplitPane.setOrientation(0);
                    jSplitPane.setTopComponent(jPanel2);
                    jSplitPane.setBottomComponent(jPanel);
                    jPanel.setPreferredSize(dimension);
                    jPanel2.setPreferredSize(dimension);
                    LocalAndRemoteFileTreeFrame.this.pack();
                    jSplitPane.setDividerLocation(0.5);
                }
            });
            jRadioButtonMenuItem.setSelected(true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButtonMenuItem);
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Horizontal Split");
            jMenu.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jSplitPane.remove(jPanel);
                    jSplitPane.remove(jPanel2);
                    jSplitPane.setOrientation(1);
                    jSplitPane.setLeftComponent(jPanel2);
                    jSplitPane.setRightComponent(jPanel);
                    jPanel.setPreferredSize(dimension);
                    jPanel2.setPreferredSize(dimension);
                    LocalAndRemoteFileTreeFrame.this.pack();
                    jSplitPane.setDividerLocation(0.5);
                }
            });
            buttonGroup.add(jRadioButtonMenuItem2);
            this.prefClose = new JMenuItem("Close");
            this.prefClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.prefClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LocalAndRemoteFileTreeFrame.this.setVisible(false);
                }
            });
            jMenu.addSeparator();
            jMenu.add(this.prefClose);
            jMenuBar.add(jMenu);
            JMenu jMenu2 = new JMenu("Help");
            jMenu2.setMnemonic(72);
            JMenuItem jMenuItem = new JMenuItem("About File Manager");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    try {
                        URL uRL = classLoader.getResource("resources/filemgr.html");
                        new Browser(uRL, "resources/filemgr.html");
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.out.println("Didn't find resources/filemgr.html");
                    }
                    catch (IOException iOException) {
                        System.out.println("Didn't find resources/filemgr.html");
                    }
                }
            });
            jMenu2.add(jMenuItem);
            jMenuBar.add(jMenu2);
            this.setJMenuBar(jMenuBar);
            remoteFileTreePanel.setPreferredSize(dimension);
            jScrollPane.setPreferredSize(dimension);
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel.add((Component)remoteFileTreePanel, "Center");
            JComboBox jComboBox = remoteFileTreePanel.getRootSelect();
            JPanel jPanel3 = new JPanel(new BorderLayout());
            Dimension dimension2 = new Dimension((int)jPanel3.getPreferredSize().getWidth(), (int)jComboBox.getMinimumSize().getHeight());
            jPanel3.add((Component)new JLabel(" LOCAL"), "West");
            jPanel3.setPreferredSize(dimension2);
            jPanel2.add((Component)jPanel3, "South");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)new JLabel(" REMOTE "), "West");
            jPanel4.add((Component)jComboBox, "East");
            jPanel4.setPreferredSize(dimension2);
            jPanel.add((Component)jPanel4, "South");
            this.getContentPane().add(jSplitPane);
            this.pack();
        }
        catch (JembossSoapException jembossSoapException) {
            throw new JembossSoapException();
        }
    }

    public void setExit() {
        this.prefClose.setText("Exit");
        this.prefClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.prefClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
    }

    public static DragTree getLocalDragTree() {
        return ltree;
    }
}

