/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class SequenceReader {
    private File seqFile;
    private Vector seqs;
    private boolean reading = false;

    public SequenceReader() {
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(null);
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        System.setSecurityManager(securityManager);
        jFileChooser.addChoosableFileFilter(new SequenceFilter());
        int n = jFileChooser.showOpenDialog(jFileChooser);
        if (n == 0) {
            this.seqFile = jFileChooser.getSelectedFile();
            this.readSequenceFile();
            this.reading = true;
        }
    }

    public SequenceReader(File file) {
        this.seqFile = file;
        this.readSequenceFile();
        this.reading = true;
    }

    public SequenceReader(String string) {
        this.readSequenceString(string);
        this.reading = true;
    }

    public boolean isReading() {
        return this.reading;
    }

    public Vector readSequenceFile() {
        BufferedReader bufferedReader = null;
        try {
            int n;
            bufferedReader = new BufferedReader(new FileReader(this.seqFile));
            String string = bufferedReader.readLine();
            if (string.startsWith(">")) {
                return this.readFastaFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            int n2 = string.indexOf("PileUp");
            if (n2 > -1) {
                return this.readMSFFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            n2 = string.indexOf("!!AA_MULTIPLE_ALIGNMENT");
            if (n2 > -1) {
                return this.readMSFFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            n2 = string.indexOf("!!NA_MULTIPLE_ALIGNMENT");
            if (n2 > -1) {
                return this.readMSFFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            n2 = string.indexOf("CLUSTAL");
            if (n2 > -1) {
                return this.readClustalFile(new BufferedReader(new FileReader(this.seqFile)));
            }
            n2 = string.indexOf(":");
            if (n2 > -1 && (n2 = string.indexOf(",", n2)) > -1 && (n = string.indexOf(",", n2 + 1)) > -1 && n - n2 == 2 && (n2 = string.indexOf(",", n + 1)) > -1 && n2 - n == 2) {
                this.readJPredFile(new BufferedReader(new FileReader(this.seqFile)));
            }
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader Error");
        }
        return null;
    }

    public Vector readSequenceString(String string) {
        BufferedReader bufferedReader = null;
        try {
            int n;
            bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            if (string2.startsWith(">")) {
                return this.readFastaFile(new BufferedReader(new StringReader(string)));
            }
            int n2 = string2.indexOf("PileUp");
            if (n2 > -1) {
                return this.readMSFFile(new BufferedReader(new StringReader(string)));
            }
            n2 = string2.indexOf("!!AA_MULTIPLE_ALIGNMENT");
            if (n2 > -1) {
                return this.readMSFFile(new BufferedReader(new StringReader(string)));
            }
            n2 = string2.indexOf("!!NA_MULTIPLE_ALIGNMENT");
            if (n2 > -1) {
                return this.readMSFFile(new BufferedReader(new StringReader(string)));
            }
            n2 = string2.indexOf("CLUSTAL");
            if (n2 > -1) {
                return this.readClustalFile(new BufferedReader(new StringReader(string)));
            }
            n2 = string2.indexOf(":");
            if (n2 > -1 && (n2 = string2.indexOf(",", n2)) > -1 && (n = string2.indexOf(",", n2 + 1)) > -1 && n - n2 == 2 && (n2 = string2.indexOf(",", n + 1)) > -1 && n2 - n == 2) {
                this.readJPredFile(new BufferedReader(new StringReader(string)));
            }
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader Error");
        }
        return null;
    }

    public Vector readFastaFile(BufferedReader bufferedReader) {
        this.seqs = new Vector();
        String string = "";
        try {
            String string2;
            String string3 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith(">")) {
                    if (!string.equals("")) {
                        this.seqs.add(new Sequence(string3, string));
                        string = "";
                        string3 = string2.substring(1);
                        continue;
                    }
                    if (!string2.startsWith(">") || !string.equals("")) continue;
                    string3 = string2.substring(1);
                    continue;
                }
                string = string.concat(string2);
            }
            bufferedReader.close();
            if (!string.equals("")) {
                this.seqs.add(new Sequence(string3, string));
            }
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader FASTA Error");
        }
        return this.seqs;
    }

    public Vector readMSFFile(BufferedReader bufferedReader) {
        this.seqs = new Vector();
        String string = "";
        try {
            String string2;
            Sequence sequence = null;
            String string3 = null;
            boolean bl = true;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (string2.startsWith("//")) {
                    bl = false;
                }
                if (string2.equals("")) continue;
                if (bl) {
                    stringTokenizer = new StringTokenizer(string2, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken(" ").trim();
                        if (string4.startsWith("Name:")) {
                            String string5 = stringTokenizer.nextToken(" ").trim();
                            sequence = new Sequence(string5, "");
                            this.seqs.add(n, sequence);
                            if (string3 != null) {
                                if (string3.equalsIgnoreCase("P")) {
                                    sequence.setType(true);
                                } else if (string3.equalsIgnoreCase("N")) {
                                    sequence.setType(false);
                                }
                            }
                            hashtable.put(string5, new Integer(n));
                            ++n;
                            continue;
                        }
                        if (string4.startsWith("Weight:")) {
                            sequence.setWeight(Float.parseFloat(stringTokenizer.nextToken().trim()));
                            continue;
                        }
                        if (!string4.startsWith("Type:")) continue;
                        string3 = stringTokenizer.nextToken(" ").trim();
                    }
                    continue;
                }
                int n2 = string2.indexOf(" ");
                if (n2 <= -1) continue;
                String string6 = string2.substring(0, n2);
                if (!hashtable.containsKey(string6)) {
                    System.out.println("Error reading sequence ");
                    continue;
                }
                stringTokenizer = new StringTokenizer(string2.substring(n2), " ");
                string = new String();
                while (stringTokenizer.hasMoreTokens()) {
                    string = string.concat(stringTokenizer.nextToken(" ").trim());
                }
                int n3 = (Integer)hashtable.get(string6);
                sequence = (Sequence)this.seqs.elementAt(n3);
                sequence.appendToSequence(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader MSF Error");
        }
        return this.seqs;
    }

    public Vector readClustalFile(BufferedReader bufferedReader) {
        this.seqs = new Vector();
        String string = "";
        try {
            String string2;
            Object var5_3 = null;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                Sequence sequence;
                int n2;
                if ((string2 = string2.trim()).equals("") || string2.startsWith("CLUSTAL ") || (n2 = string2.indexOf(" ")) <= -1) continue;
                String string3 = string2.substring(0, n2);
                if (!hashtable.containsKey(string3)) {
                    hashtable.put(string3, new Integer(n));
                    sequence = new Sequence(string3, "");
                    this.seqs.add(n++, sequence);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n2), " ");
                string = new String();
                while (stringTokenizer.hasMoreTokens()) {
                    string = string.concat(stringTokenizer.nextToken(" ").trim());
                }
                int n3 = (Integer)hashtable.get(string3);
                sequence = (Sequence)this.seqs.elementAt(n3);
                sequence.appendToSequence(string);
            }
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader Clutal Error");
        }
        return this.seqs;
    }

    public Vector readJPredFile(BufferedReader bufferedReader) {
        this.seqs = new Vector();
        System.out.println("readJPredFile");
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if ((string = string.trim()).equals("") || (n = string.indexOf(":")) <= -1) continue;
                int n2 = string.indexOf(";") + 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                String string2 = string.substring(n2, n);
                string = string.substring(n + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer = stringBuffer.append(stringTokenizer.nextToken(",").trim());
                }
                Sequence sequence = new Sequence(string2, stringBuffer.toString());
                this.seqs.add(sequence);
            }
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader JPred Error");
        }
        return this.seqs;
    }

    public int getNumberOfSequences() {
        return this.seqs.size();
    }

    public Sequence getSequence(int n) {
        return (Sequence)this.seqs.get(n);
    }

    public Vector getSequenceVector() {
        return this.seqs;
    }

    public File getSequenceFile() {
        return this.seqFile;
    }
}

