/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public final class ExecutorServiceHelper {
    public static final String DEFAULT_PATTERN = "Camel Thread ${counter} - ${name}";
    private static AtomicInteger threadCounter = new AtomicInteger();

    private ExecutorServiceHelper() {
    }

    private static synchronized int nextThreadCounter() {
        return threadCounter.getAndIncrement();
    }

    public static String getThreadName(String pattern, String name) {
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        String longName = name;
        String shortName = name.contains("?") ? ObjectHelper.before(name, "?") : name;
        String answer = pattern.replaceFirst("\\$\\{counter\\}", "" + ExecutorServiceHelper.nextThreadCounter());
        answer = answer.replaceFirst("\\$\\{longName\\}", longName);
        if ((answer = answer.replaceFirst("\\$\\{name\\}", shortName)).indexOf("$") > -1 || answer.indexOf("${") > -1 || answer.indexOf("}") > -1) {
            throw new IllegalArgumentException("Pattern is invalid: " + pattern);
        }
        return answer;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, final String pattern, final String name, final boolean daemon) {
        return Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(pattern, name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newFixedThreadPool(int poolSize, final String pattern, final String name, final boolean daemon) {
        return Executors.newFixedThreadPool(poolSize, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(pattern, name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newSingleThreadExecutor(final String pattern, final String name, final boolean daemon) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(pattern, name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newCachedThreadPool(final String pattern, final String name, final boolean daemon) {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(pattern, name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newThreadPool(String pattern, String name, int corePoolSize, int maxPoolSize) {
        return ExecutorServiceHelper.newThreadPool(pattern, name, corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, -1, new ThreadPoolExecutor.CallerRunsPolicy(), true);
    }

    public static ExecutorService newThreadPool(final String pattern, final String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, final boolean daemon) {
        if (maxPoolSize < corePoolSize) {
            throw new IllegalArgumentException("MaxPoolSize must be >= corePoolSize, was " + maxPoolSize + " >= " + corePoolSize);
        }
        AbstractQueue queue = corePoolSize == 0 && maxQueueSize <= 0 ? new SynchronousQueue() : (maxQueueSize <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(maxQueueSize));
        ThreadPoolExecutor answer = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, (BlockingQueue<Runnable>)((Object)queue));
        answer.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(pattern, name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        }
        answer.setRejectedExecutionHandler(rejectedExecutionHandler);
        return answer;
    }

    public static ExecutorService getConfiguredExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition definition) throws IllegalArgumentException {
        ExecutorServiceStrategy strategy = routeContext.getCamelContext().getExecutorServiceStrategy();
        ObjectHelper.notNull(strategy, "ExecutorServiceStrategy", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return definition.getExecutorService();
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = strategy.lookup(definition, name, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry.");
            }
            return answer;
        }
        return null;
    }

    public static ScheduledExecutorService getConfiguredScheduledExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition definition) throws IllegalArgumentException {
        ExecutorServiceStrategy strategy = routeContext.getCamelContext().getExecutorServiceStrategy();
        ObjectHelper.notNull(strategy, "ExecutorServiceStrategy", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            ExecutorService executorService = definition.getExecutorService();
            if (executorService instanceof ScheduledExecutorService) {
                return (ScheduledExecutorService)executorService;
            }
            throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " is not an ScheduledExecutorService instance");
        }
        if (definition.getExecutorServiceRef() != null) {
            ScheduledExecutorService answer = strategy.lookupScheduled(definition, name, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry.");
            }
            return answer;
        }
        return null;
    }
}

