/* 
 * Copyright 2011 Vaadin Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.vaadin.client.metadata;

import com.google.gwt.core.client.RunAsyncCallback;

public abstract class TypeDataBundle implements RunAsyncCallback {
    private final String name;

    public TypeDataBundle(String name) {
        this.name = name;
    }

    @Override
    public void onSuccess() {
        ConnectorBundleLoader loader = ConnectorBundleLoader.get();
        load();
        loader.setLoaded(getName());
    }

    @Override
    public void onFailure(Throwable reason) {
        ConnectorBundleLoader.get().setLoadFailure(getName(), reason);
    }

    public abstract void load();

    public String getName() {
        return name;
    }
}
