/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.IConfigurationListener;
import org.testng.internal.IInvoker;
import org.testng.internal.IMethodWorker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.InvokedMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.Parameters;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker
implements IInvoker {
    private ITestContext m_testContext;
    private ITestResultNotifier m_notifier;
    private IAnnotationFinder m_annotationFinder;
    private SuiteRunState m_suiteState;
    private boolean m_skipFailedInvocationCounts;
    private List<IInvokedMethodListener> m_invokedMethodListeners;
    private Map<String, Boolean> m_beforegroupsFailures = new Hashtable<String, Boolean>();
    private Map<Class<?>, Boolean> m_classInvocationResults = new Hashtable();

    public Invoker(ITestContext testContext, ITestResultNotifier notifier, SuiteRunState state, IAnnotationFinder annotationFinder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
        this.m_testContext = testContext;
        this.m_suiteState = state;
        this.m_notifier = notifier;
        this.m_annotationFinder = annotationFinder;
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.m_invokedMethodListeners = invokedMethodListeners;
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance) {
        this.invokeConfigurations(testClass, null, allMethods, suite, params, parameterValues, instance);
    }

    private void invokeConfigurations(IClass testClass, ITestNGMethod currentTestMethod, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance) {
        ITestNGMethod[] methods;
        if (null == allMethods) {
            this.log(5, "No @Configuration methods found");
            return;
        }
        for (ITestNGMethod tm : methods = this.filterMethodsUnique(testClass, allMethods)) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            TestResult testResult = new TestResult(testClass, instance, tm, null, System.currentTimeMillis(), System.currentTimeMillis());
            IConfigurationAnnotation configurationAnnotation = null;
            try {
                Object[] instances = tm.getInstances();
                if (instances == null || instances.length == 0) {
                    instances = new Object[]{instance};
                }
                Class<?> objectClass = instances[0].getClass();
                Method method = tm.getMethod();
                if (MethodHelper.isEnabled(objectClass, this.m_annotationFinder)) {
                    configurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, method);
                    if (MethodHelper.isEnabled(configurationAnnotation)) {
                        Object[] objectArray;
                        boolean isClassConfiguration = this.isClassConfiguration(configurationAnnotation);
                        boolean alwaysRun = this.isAlwaysRun(configurationAnnotation);
                        if (!this.confInvocationPassed(tm) && !alwaysRun) {
                            this.handleConfigurationSkip(tm, testResult, configurationAnnotation, suite);
                            continue;
                        }
                        this.log(3, "Invoking " + Utils.detailedMethodName(tm, true));
                        Object[] parameters = Parameters.createConfigurationParameters(tm.getMethod(), params, parameterValues, currentTestMethod, this.m_annotationFinder, suite, this.m_testContext);
                        testResult.setParameters(parameters);
                        if (null != instance) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = instance;
                        } else {
                            objectArray = instances;
                        }
                        Object[] newInstances = objectArray;
                        this.invokeConfigurationMethod(newInstances, tm, parameters, isClassConfiguration, testResult);
                        testResult.setEndMillis(System.currentTimeMillis());
                        this.runConfigurationListeners(testResult);
                        continue;
                    }
                    this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because it is not enabled");
                    continue;
                }
                this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because " + objectClass.getName() + " is not enabled");
            }
            catch (InvocationTargetException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
            catch (TestNGException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
        }
    }

    private void handleConfigurationSkip(ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, XmlSuite suite) {
        this.recordConfigurationInvocationFailed(tm, annotation, suite);
        testResult.setStatus(3);
        this.runConfigurationListeners(testResult);
    }

    private boolean isClassConfiguration(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean before = null != configurationAnnotation ? configurationAnnotation.getBeforeTestClass() : false;
        boolean after = null != configurationAnnotation ? configurationAnnotation.getAfterTestClass() : false;
        return before || after;
    }

    private boolean isAlwaysRun(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean alwaysRun = false;
        if ((configurationAnnotation.getAfterSuite() || configurationAnnotation.getAfterTest() || configurationAnnotation.getAfterTestClass() || configurationAnnotation.getAfterTestMethod()) && configurationAnnotation.getAlwaysRun()) {
            alwaysRun = true;
        }
        return alwaysRun;
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, XmlSuite suite) {
        SkipException skipEx;
        Throwable cause;
        Throwable throwable = cause = ite.getCause() != null ? ite.getCause() : ite;
        if (SkipException.class.isAssignableFrom(cause.getClass()) && (skipEx = (SkipException)cause).isSkip()) {
            testResult.setThrowable(skipEx);
            this.handleConfigurationSkip(tm, testResult, annotation, suite);
            return;
        }
        Utils.log("", 3, "Failed to invoke @Configuration method " + tm.getRealClass().getName() + "." + tm.getMethodName() + ":" + cause.getMessage());
        this.handleException(cause, tm, testResult, 1);
        this.runConfigurationListeners(testResult);
        if (null != annotation) {
            this.recordConfigurationInvocationFailed(tm, annotation, suite);
        }
    }

    private XmlClass[] findClassesInSameTest(Class<?> cls, XmlSuite suite) {
        HashMap<String, XmlClass> vResult = new HashMap<String, XmlClass>();
        String className = cls.getName();
        for (XmlTest test : suite.getTests()) {
            for (XmlClass testClass : test.getXmlClasses()) {
                if (!testClass.getName().equals(className)) continue;
                for (XmlClass thisClass : test.getXmlClasses()) {
                    vResult.put(thisClass.getName(), thisClass);
                }
            }
        }
        XmlClass[] result = vResult.values().toArray(new XmlClass[vResult.size()]);
        return result;
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod tm, IConfigurationAnnotation annotation, XmlSuite suite) {
        if (annotation.getBeforeTestClass() || annotation.getAfterTestClass() || annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
            this.setClassInvocationFailure(tm.getRealClass(), false);
        } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
            this.setClassInvocationFailure(tm.getRealClass(), false);
            XmlClass[] classes = this.findClassesInSameTest(tm.getRealClass(), suite);
            for (XmlClass xmlClass : classes) {
                this.setClassInvocationFailure(xmlClass.getSupportClass(), false);
            }
        }
        String[] beforeGroups = annotation.getBeforeGroups();
        if (null != beforeGroups && beforeGroups.length > 0) {
            for (String group : beforeGroups) {
                this.m_beforegroupsFailures.put(group, Boolean.FALSE);
            }
        }
    }

    private boolean confInvocationPassed(ITestNGMethod method) {
        boolean result = true;
        Class<?> cls = method.getMethod().getDeclaringClass();
        if (this.m_suiteState.isFailed()) {
            result = false;
        } else if (this.m_classInvocationResults.containsKey(cls)) {
            result = this.m_classInvocationResults.get(cls);
        } else {
            for (Class<?> clazz : this.m_classInvocationResults.keySet()) {
                if (!clazz.isAssignableFrom(cls)) continue;
                result = false;
                break;
            }
        }
        String[] groups = method.getGroups();
        if (null != groups && groups.length > 0) {
            for (String group : groups) {
                if (!this.m_beforegroupsFailures.containsKey(group)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private void setClassInvocationFailure(Class<?> clazz, boolean flag) {
        this.m_classInvocationResults.put(clazz, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConfigurationMethod(Object[] instances, ITestNGMethod tm, Object[] params, boolean isClass, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(ThreadUtil.currentThreadInfo());
        for (Object targetInstance : instances) {
            InvokedMethod im = new InvokedMethod(targetInstance, tm, params, false, isClass, System.currentTimeMillis());
            this.runInvokedMethodListeners(true, im, testResult);
            this.m_notifier.addInvokedMethod(im);
            try {
                Reporter.setCurrentTestResult(testResult);
                MethodHelper.invokeMethod(tm.getMethod(), targetInstance, params);
            }
            finally {
                Reporter.setCurrentTestResult(testResult);
                this.runInvokedMethodListeners(false, im, testResult);
            }
        }
    }

    private void runInvokedMethodListeners(boolean before, IInvokedMethod method, ITestResult testResult) {
        block4: {
            if (this.m_invokedMethodListeners == null) break block4;
            if (before) {
                for (IInvokedMethodListener l : this.m_invokedMethodListeners) {
                    l.beforeInvocation(method, testResult);
                }
            } else {
                for (IInvokedMethodListener l : this.m_invokedMethodListeners) {
                    l.afterInvocation(method, testResult);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITestResult invokeMethod(Object[] instances, int instanceIndex, ITestNGMethod tm, Object[] parameterValues, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods) {
        this.invokeBeforeGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[instanceIndex]);
        this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, beforeMethods, true), suite, params, parameterValues, instances[instanceIndex]);
        TestResult testResult = null;
        InvokedMethod invokedMethod = null;
        try {
            try {
                testResult = new TestResult(testClass, instances[instanceIndex], tm, null, System.currentTimeMillis(), 0L);
                testResult.setParameters(parameterValues);
                testResult.setHost(this.m_testContext.getHost());
                testResult.setStatus(16);
                this.runTestListeners(testResult);
                invokedMethod = new InvokedMethod(instances[instanceIndex], tm, parameterValues, true, false, System.currentTimeMillis());
                this.runInvokedMethodListeners(true, invokedMethod, testResult);
                this.m_notifier.addInvokedMethod(invokedMethod);
                Method thisMethod = tm.getMethod();
                if (this.confInvocationPassed(tm)) {
                    this.log(3, "Invoking " + thisMethod.getDeclaringClass().getName() + "." + thisMethod.getName());
                    if (MethodHelper.calculateTimeOut(tm) <= 0L) {
                        try {
                            Reporter.setCurrentTestResult(testResult);
                            if (IHookable.class.isAssignableFrom(thisMethod.getDeclaringClass())) {
                                MethodHelper.invokeHookable(instances[instanceIndex], parameterValues, testClass, thisMethod, testResult);
                            } else {
                                MethodHelper.invokeMethod(thisMethod, instances[instanceIndex], parameterValues);
                            }
                            testResult.setStatus(1);
                            Object var15_17 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_18 = null;
                            Reporter.setCurrentTestResult(null);
                            throw throwable;
                        }
                        Reporter.setCurrentTestResult(null);
                    }
                    try {
                        Reporter.setCurrentTestResult(testResult);
                        MethodHelper.invokeWithTimeout(tm, instances[instanceIndex], parameterValues, testResult);
                        Object var17_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_22 = null;
                        Reporter.setCurrentTestResult(null);
                        throw throwable;
                    }
                    Reporter.setCurrentTestResult(null);
                }
                testResult.setStatus(3);
            }
            catch (InvocationTargetException ite) {
                testResult.setThrowable(ite.getCause());
                Object var19_25 = null;
                this.runInvokedMethodListeners(false, invokedMethod, testResult);
                Class<?>[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
                ArrayList<ITestResult> results = new ArrayList<ITestResult>();
                results.add(testResult);
                this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instances[instanceIndex]);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[instanceIndex]);
                return testResult;
            }
            catch (ThreadExecutionException tee) {
                Throwable cause = tee.getCause();
                if (InvokeMethodRunnable.TestNGRuntimeException.class.equals(cause.getClass())) {
                    testResult.setThrowable(cause.getCause());
                } else {
                    testResult.setThrowable(cause);
                }
                Object var19_26 = null;
                this.runInvokedMethodListeners(false, invokedMethod, testResult);
                Class<?>[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
                ArrayList<ITestResult> results = new ArrayList<ITestResult>();
                results.add(testResult);
                this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instances[instanceIndex]);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[instanceIndex]);
                return testResult;
            }
            catch (Throwable thr) {
                testResult.setThrowable(thr);
                Object var19_27 = null;
                this.runInvokedMethodListeners(false, invokedMethod, testResult);
                Class<?>[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
                ArrayList<ITestResult> results = new ArrayList<ITestResult>();
                results.add(testResult);
                this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instances[instanceIndex]);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[instanceIndex]);
                return testResult;
            }
            Object var19_24 = null;
            this.runInvokedMethodListeners(false, invokedMethod, testResult);
        }
        catch (Throwable throwable) {
            Object var19_28 = null;
            this.runInvokedMethodListeners(false, invokedMethod, testResult);
            Class<?>[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
            ArrayList<ITestResult> results = new ArrayList<ITestResult>();
            results.add(testResult);
            this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
            tm.incrementCurrentInvocationCount();
            if (testResult != null) {
                testResult.setEndMillis(System.currentTimeMillis());
            }
            this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instances[instanceIndex]);
            this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[instanceIndex]);
            throw throwable;
        }
        Class<?>[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        results.add(testResult);
        this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
        tm.incrementCurrentInvocationCount();
        if (testResult != null) {
            testResult.setEndMillis(System.currentTimeMillis());
        }
        this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instances[instanceIndex]);
        this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[instanceIndex]);
        return testResult;
    }

    private ITestNGMethod[] filterConfigurationMethods(ITestNGMethod tm, ITestNGMethod[] methods, boolean isBefore) {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod m : methods) {
            ConfigurationMethod cm = (ConfigurationMethod)m;
            if (isBefore) {
                if (cm.isFirstTimeOnly() && (!cm.isFirstTimeOnly() || tm.getCurrentInvocationCount() != 0)) continue;
                result.add(m);
                continue;
            }
            int current = tm.getCurrentInvocationCount();
            boolean isLast = false;
            if (tm.getParameterInvocationCount() > 0) {
                isLast = current == tm.getParameterInvocationCount();
            } else if (tm.getInvocationCount() > 1) {
                boolean bl = isLast = current == tm.getInvocationCount();
            }
            if (cm.isLastTimeOnly() && (!cm.isLastTimeOnly() || !isLast)) continue;
            result.add(m);
        }
        return result.toArray(new ITestNGMethod[result.size()]);
    }

    private List<ITestResult> invokeTestMethod(Object[] instances, ITestNGMethod tm, Object[] parameterValues, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods) {
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        tm.setId(ThreadUtil.currentThreadInfo());
        for (int i = 0; i < instances.length; ++i) {
            results.add(this.invokeMethod(instances, i, tm, parameterValues, suite, params, testClass, beforeMethods, afterMethods, groupMethods));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBeforeGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            ArrayList<ITestNGMethod> filteredMethods = new ArrayList<ITestNGMethod>();
            String[] groups = currentTestMethod.getGroups();
            Map<String, List<ITestNGMethod>> beforeGroupMap = groupMethods.getBeforeGroupsMap();
            for (String group : groups) {
                List<ITestNGMethod> methods = beforeGroupMap.get(group);
                if (methods == null) continue;
                filteredMethods.addAll(methods);
            }
            ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[filteredMethods.size()]);
            if (beforeMethodsArray.length > 0) {
                this.invokeConfigurations(null, beforeMethodsArray, suite, params, null, null);
            }
            groupMethods.removeBeforeGroups(groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAfterGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        if (currentTestMethod.getGroups().length == 0) {
            return;
        }
        HashMap<String, String> filteredGroups = new HashMap<String, String>();
        String[] groups = currentTestMethod.getGroups();
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            for (String group : groups) {
                if (!groupMethods.isLastMethodForGroup(group, currentTestMethod)) continue;
                filteredGroups.put(group, group);
            }
            if (filteredGroups.isEmpty()) {
                return;
            }
            HashMap<ITestNGMethod, ITestNGMethod> afterMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
            Map<String, List<ITestNGMethod>> map = groupMethods.getAfterGroupsMap();
            for (String g : filteredGroups.values()) {
                List<ITestNGMethod> methods = map.get(g);
                if (methods == null) continue;
                for (ITestNGMethod m : methods) {
                    afterMethods.put(m, m);
                }
            }
            ITestNGMethod[] afterMethodsArray = afterMethods.keySet().toArray(new ITestNGMethod[afterMethods.size()]);
            this.invokeConfigurations(null, afterMethodsArray, suite, params, null, null);
            groupMethods.removeAfterGroups(filteredGroups.keySet());
        }
    }

    private Object[] getParametersFromIndex(Iterator<Object[]> parametersValues, int index) {
        while (parametersValues.hasNext()) {
            Object[] parameters = parametersValues.next();
            if (index == 0) {
                return parameters;
            }
            --index;
        }
        return null;
    }

    private int retryFailed(Object[] instances, int instanceIndex, ITestNGMethod tm, XmlSuite suite, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, List<ITestResult> result, int failureCount, Class<?>[] expectedExceptionClasses, ITestContext testContext, Map<String, String> parameters, int parametersIndex) {
        ArrayList<Object> failedInstances;
        do {
            failedInstances = new ArrayList<Object>();
            HashMap<String, String> allParameters = new HashMap<String, String>();
            ParameterBag bag = this.createParameters(testClass, tm, parameters, allParameters, null, suite, testContext, null);
            Object[] parameterValues = this.getParametersFromIndex(bag.parameterValues, parametersIndex);
            result.add(this.invokeMethod(instances, instanceIndex, tm, parameterValues, suite, allParameters, testClass, beforeMethods, afterMethods, groupMethods));
            failureCount = this.handleInvocationResults(tm, result, failedInstances, failureCount, expectedExceptionClasses, true, true);
        } while (!failedInstances.isEmpty());
        return failureCount;
    }

    private ParameterBag createParameters(ITestClass testClass, ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, Object[] parameterValues, XmlSuite suite, ITestContext testContext, Object fedInstance) {
        Object instance;
        if (fedInstance != null) {
            instance = fedInstance;
        } else {
            Object[] instances = testClass.getInstances(true);
            instance = instances[0];
        }
        ParameterBag bag = this.handleParameters(testMethod, instance, allParameterNames, parameters, parameterValues, suite, testContext, fedInstance);
        return bag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, int testMethodIndex, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, Object[] instances, ITestContext testContext) {
        assert (null != testMethod.getTestClass()) : "COULDN'T FIND TESTCLASS FOR " + testMethod.getMethod().getDeclaringClass();
        ArrayList<ITestResult> result = new ArrayList<ITestResult>();
        ITestClass testClass = testMethod.getTestClass();
        long start = System.currentTimeMillis();
        long timeOutInvocationCount = testMethod.getInvocationTimeOut();
        boolean onlyOne = testMethod.getThreadPoolSize() > 1 || timeOutInvocationCount > 0L;
        int invocationCount = onlyOne ? 1 : testMethod.getInvocationCount();
        int failureCount = 0;
        Class<?>[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, testMethod.getMethod());
        while (invocationCount-- > 0) {
            boolean okToProceed = this.checkDependencies(testMethod, testClass, allTestMethods);
            if (okToProceed) {
                Object v0;
                if (!MethodHelper.isEnabled(testMethod.getMethod(), this.m_annotationFinder)) continue;
                if (testMethod.getThreadPoolSize() > 1 && testMethod.getInvocationCount() > 1) {
                    return this.invokePooledTestMethods(testMethod, allTestMethods, suite, parameters, groupMethods, testContext);
                }
                ITestNGMethod[] beforeMethods = this.filterMethods(testClass, testClass.getBeforeTestMethods());
                ITestNGMethod[] afterMethods = this.filterMethods(testClass, testClass.getAfterTestMethods());
                HashMap<String, String> allParameterNames = new HashMap<String, String>();
                ParameterBag bag = this.createParameters(testClass, testMethod, parameters, allParameterNames, null, suite, testContext, instances[0]);
                if (bag.hasErrors()) {
                    failureCount = this.handleInvocationResults(testMethod, bag.errorResults, null, failureCount, expectedExceptionClasses, true, true);
                    continue;
                }
                Iterator<Object[]> allParameterValues = bag.parameterValues;
                if (testMethod.getThreadPoolSize() > 1) {
                    return this.invokePooledTestMethods(instances, testMethod, allTestMethods, beforeMethods, afterMethods, groupMethods, suite, parameters, allParameterNames, allParameterValues);
                }
                int parametersIndex = 0;
                if (!allParameterValues.hasNext()) continue;
                Object[] parameterValues = allParameterValues.next();
                ArrayList<ITestResult> tmpResults = new ArrayList<ITestResult>();
                try {
                    tmpResults.addAll(this.invokeTestMethod(instances, testMethod, parameterValues, suite, parameters, testClass, beforeMethods, afterMethods, groupMethods));
                    v0 = null;
                }
                catch (Throwable throwable) {
                    v0 = null;
                }
                Object var29_27 = v0;
                ArrayList<Object> failedInstances = new ArrayList<Object>();
                failureCount = this.handleInvocationResults(testMethod, tmpResults, failedInstances, failureCount, expectedExceptionClasses, true, false);
                if (failedInstances.isEmpty()) {
                    result.addAll(tmpResults);
                } else {
                    for (int i = 0; i < failedInstances.size(); ++i) {
                        ArrayList<ITestResult> retryResults = new ArrayList<ITestResult>();
                        failureCount = this.retryFailed(failedInstances.toArray(), i, testMethod, suite, testClass, beforeMethods, afterMethods, groupMethods, retryResults, failureCount, expectedExceptionClasses, testContext, parameters, parametersIndex);
                        result.addAll(retryResults);
                    }
                }
                if (!this.m_skipFailedInvocationCounts) {
                    this.m_skipFailedInvocationCounts = testMethod.skipFailedInvocations();
                }
                if (failureCount > 0 && this.m_skipFailedInvocationCounts) {
                    while (invocationCount-- > 0) {
                        TestResult r = new TestResult(testMethod.getTestClass(), instances[0], testMethod, null, start, System.currentTimeMillis());
                        r.setStatus(3);
                        result.add(r);
                        this.runTestListeners(r);
                        this.m_notifier.addSkippedTest(testMethod, r);
                    }
                    continue;
                }
                // JSR Ret
            }
            TestResult testResult = new TestResult(testClass, null, testMethod, null, start, System.currentTimeMillis());
            testResult.setEndMillis(System.currentTimeMillis());
            String missingGroup = testMethod.getMissingGroup();
            if (missingGroup != null) {
                testResult.setThrowable(new Throwable("Method " + testMethod + " depends on nonexistent group \"" + missingGroup + "\""));
            }
            testResult.setStatus(3);
            this.m_notifier.addSkippedTest(testMethod, testResult);
            this.runTestListeners(testResult);
        }
        return result;
    }

    private ParameterBag handleParameters(ITestNGMethod testMethod, Object instance, Map<String, String> allParameterNames, Map<String, String> parameters, Object[] parameterValues, XmlSuite suite, ITestContext testContext, Object fedInstance) {
        try {
            return new ParameterBag(Parameters.handleParameters(testMethod, allParameterNames, instance, new Parameters.MethodParameters(parameters, parameterValues, testMethod.getMethod(), testContext), suite, this.m_annotationFinder, fedInstance), null);
        }
        catch (Throwable cause) {
            return new ParameterBag(null, new TestResult(testMethod.getTestClass(), instance, testMethod, cause, System.currentTimeMillis(), System.currentTimeMillis()));
        }
    }

    private List<ITestResult> invokePooledTestMethods(Object[] instances, ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> parameters, Map<String, String> allParameterNames, Iterator<Object[]> allParameterValues) {
        ArrayList<IMethodWorker> workers = new ArrayList<IMethodWorker>();
        while (allParameterValues.hasNext()) {
            Object[] parameterValues = allParameterValues.next();
            workers.add(new DataTestMethodWorker(instances, testMethod.clone(), parameterValues, beforeMethods, afterMethods, groupMethods, suite, allParameterNames));
        }
        return this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize(), groupMethods, suite, parameters);
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ITestContext testContext) {
        ArrayList<IMethodWorker> workers = new ArrayList<IMethodWorker>();
        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
            ITestNGMethod clonedMethod = testMethod.clone();
            clonedMethod.setInvocationCount(1);
            clonedMethod.setThreadPoolSize(1);
            MethodInstance mi = new MethodInstance(clonedMethod, clonedMethod.getTestClass().getInstances(true));
            workers.add(new SingleTestMethodWorker(this, mi, suite, parameters, allTestMethods, testContext));
        }
        return this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize(), groupMethods, suite, parameters);
    }

    private int handleInvocationResults(ITestNGMethod testMethod, List<ITestResult> result, List<Object> failedInstances, int failureCount, Class<?>[] expectedExceptionClasses, boolean triggerListeners, boolean collectResults) {
        ArrayList<ITestResult> resultsToRetry = new ArrayList<ITestResult>();
        for (int i = 0; i < result.size(); ++i) {
            ITestResult testResult = result.get(i);
            Throwable ite = testResult.getThrowable();
            int status = testResult.getStatus();
            if (ite != null) {
                if (this.isExpectedException(ite, expectedExceptionClasses)) {
                    testResult.setStatus(1);
                    status = 1;
                } else if (SkipException.class.isAssignableFrom(ite.getClass())) {
                    SkipException skipEx = (SkipException)ite;
                    if (skipEx.isSkip()) {
                        status = 3;
                    } else {
                        this.handleException(ite, testMethod, testResult, failureCount++);
                        status = 2;
                    }
                } else {
                    this.handleException(ite, testMethod, testResult, failureCount++);
                    status = testResult.getStatus();
                }
            } else if (status != 3 && expectedExceptionClasses.length > 0) {
                testResult.setThrowable(new TestException("Expected an exception in test method " + testMethod));
                status = 2;
            }
            testResult.setStatus(status);
            boolean retry = false;
            if (testResult.getStatus() == 2) {
                IRetryAnalyzer retryAnalyzer = testMethod.getRetryAnalyzer();
                if (retryAnalyzer != null) {
                    retry = retryAnalyzer.retry(testResult);
                }
                if (retry) {
                    resultsToRetry.add(testResult);
                    if (failedInstances != null) {
                        failedInstances.add(testResult.getMethod().getInstances()[i]);
                    }
                }
            }
            if (retry && !collectResults) continue;
            if (1 == status) {
                this.m_notifier.addPassedTest(testMethod, testResult);
            } else if (3 == status) {
                this.m_notifier.addSkippedTest(testMethod, testResult);
            } else if (2 == status) {
                this.m_notifier.addFailedTest(testMethod, testResult);
            } else if (4 == status) {
                this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, testResult);
            } else assert (false) : "UNKNOWN STATUS:" + status;
            if (!triggerListeners) continue;
            this.runTestListeners(testResult);
        }
        return this.removeResultsToRetryFromResult(resultsToRetry, result, failureCount);
    }

    private int removeResultsToRetryFromResult(List<ITestResult> resultsToRetry, List<ITestResult> result, int failureCount) {
        if (resultsToRetry != null) {
            for (ITestResult res : resultsToRetry) {
                result.remove(res);
                --failureCount;
            }
        }
        return failureCount;
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<IMethodWorker> workers, int threadPoolSize, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> parameters) {
        Object[] instances;
        ITestClass testClass = testMethod.getTestClass();
        for (Object instance : instances = testClass.getInstances(true)) {
            this.invokeBeforeGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        long maxTimeOut = -1L;
        for (IMethodWorker tmw : workers) {
            long mt = tmw.getMaxTimeOut();
            if (mt <= maxTimeOut) continue;
            maxTimeOut = mt;
        }
        ThreadUtil.execute(workers, threadPoolSize, maxTimeOut, true);
        ArrayList<ITestResult> result = new ArrayList<ITestResult>();
        for (IMethodWorker tmw : workers) {
            result.addAll(tmw.getTestResults());
        }
        for (Object instance : instances) {
            this.invokeAfterGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        return result;
    }

    private boolean checkDependencies(ITestNGMethod testMethod, ITestClass testClass, ITestNGMethod[] allTestMethods) {
        boolean result = true;
        if (testMethod.isAlwaysRun()) {
            return true;
        }
        if (testMethod.getMissingGroup() != null && !testMethod.ignoreMissingDependencies()) {
            return false;
        }
        if (this.dependsOnGroups(testMethod)) {
            String[] groupsDependedUpon = testMethod.getGroupsDependedUpon();
            for (int i = 0; i < groupsDependedUpon.length; ++i) {
                ITestNGMethod[] methods = MethodHelper.findMethodsThatBelongToGroup(testMethod, this.m_testContext.getAllTestMethods(), groupsDependedUpon[i]);
                result = result && this.haveBeenRunSuccessfully(methods);
            }
        }
        if (this.dependsOnMethods(testMethod)) {
            ITestNGMethod[] methods = MethodHelper.findMethodsNamed(testMethod, allTestMethods, testMethod.getMethodsDependedUpon());
            result = result && this.haveBeenRunSuccessfully(methods);
        }
        return result;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod[] methods) {
        for (int j = 0; j < methods.length; ++j) {
            Set<ITestResult> results = this.m_notifier.getPassedTests(methods[j]);
            if (results == null || results.size() == 0) {
                return false;
            }
            for (ITestResult result : results) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        testResult.setThrowable(throwable);
        int successPercentage = testMethod.getSuccessPercentage();
        int invocationCount = testMethod.getInvocationCount();
        float numberOfTestsThatCanFail = (100 - successPercentage) * invocationCount / 100;
        if ((float)failureCount < numberOfTestsThatCanFail) {
            testResult.setStatus(4);
        } else {
            testResult.setStatus(2);
        }
    }

    private boolean isExpectedException(Throwable ite, Class<?>[] exceptions) {
        if (null == exceptions) {
            return false;
        }
        Class<?> realExceptionClass = ite.getClass();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!exceptions[i].isAssignableFrom(realExceptionClass)) continue;
            return true;
        }
        return false;
    }

    private ITestNGMethod[] filterMethods(IClass testClass, ITestNGMethod[] methods) {
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            if (tm.canRunFromClass(testClass)) {
                this.log(9, "Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private ITestNGMethod[] filterMethodsUnique(IClass testClass, ITestNGMethod[] methods) {
        if (null == testClass) {
            return methods;
        }
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            if (tm.getTestClass().getName().equals(testClass.getName())) {
                this.log(9, "        Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "        Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private boolean dependsOnGroups(ITestNGMethod tm) {
        String[] groups = tm.getGroupsDependedUpon();
        boolean result = null != groups && groups.length > 0;
        return result;
    }

    private boolean dependsOnMethods(ITestNGMethod tm) {
        String[] methods = tm.getMethodsDependedUpon();
        boolean result = null != methods && methods.length > 0;
        return result;
    }

    private void runConfigurationListeners(ITestResult tr) {
        for (IConfigurationListener icl : this.m_notifier.getConfigurationListeners()) {
            switch (tr.getStatus()) {
                case 3: {
                    icl.onConfigurationSkip(tr);
                    break;
                }
                case 2: {
                    icl.onConfigurationFailure(tr);
                    break;
                }
                case 1: {
                    icl.onConfigurationSuccess(tr);
                }
            }
        }
    }

    private void runTestListeners(ITestResult tr) {
        Invoker.runTestListeners(tr, this.m_notifier.getTestListeners());
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            assert (false) : "UNKNOWN STATUS:" + tr;
        }
    }

    private static void ppp(String s) {
        System.out.println("[Invoker]" + s);
    }

    private void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterBag {
        final Iterator<Object[]> parameterValues;
        final List<ITestResult> errorResults = new ArrayList<ITestResult>();

        public ParameterBag(Iterator<Object[]> params, TestResult tr) {
            this.parameterValues = params;
            if (tr != null) {
                this.errorResults.add(tr);
            }
        }

        public boolean hasErrors() {
            return !this.errorResults.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataTestMethodWorker
    implements IMethodWorker {
        final Object[] m_instances;
        final ITestNGMethod m_testMethod;
        final ITestNGMethod[] m_beforeMethods;
        final ITestNGMethod[] m_afterMethods;
        final ConfigurationGroupMethods m_groupMethods;
        final Object[] m_parameters;
        final XmlSuite m_suite;
        final Map<String, String> m_allParameterNames;
        List<ITestResult> m_results;

        public DataTestMethodWorker(Object[] instances, ITestNGMethod testMethod, Object[] params, ITestNGMethod[] befores, ITestNGMethod[] afters, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> paramNames) {
            this.m_instances = instances;
            this.m_testMethod = testMethod;
            this.m_parameters = params;
            this.m_beforeMethods = befores;
            this.m_afterMethods = afters;
            this.m_groupMethods = groupMethods;
            this.m_suite = suite;
            this.m_allParameterNames = paramNames;
        }

        @Override
        public long getMaxTimeOut() {
            return 0L;
        }

        @Override
        public void run() {
            this.m_results = Invoker.this.invokeTestMethod(this.m_instances, this.m_testMethod, this.m_parameters, this.m_suite, this.m_allParameterNames, this.m_testMethod.getTestClass(), this.m_beforeMethods, this.m_afterMethods, this.m_groupMethods);
        }

        @Override
        public List<ITestResult> getTestResults() {
            return this.m_results;
        }
    }
}

