/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.gui.ShowResultSet;
import org.emboss.jemboss.gui.filetree.FileNode;
import org.emboss.jemboss.gui.filetree.FileSave;
import org.emboss.jemboss.gui.filetree.RemoteFileNode;
import org.emboss.jemboss.soap.PrivateRequest;

public class DragTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
ActionListener,
Autoscroll {
    private JembossParams mysettings;
    private File root;
    private Vector openNode;
    private String fs = new String(System.getProperty("file.separator"));
    private JPopupMenu popup;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private static final int AUTOSCROLL_MARGIN = 45;
    private Insets autoscrollInsets = new Insets(0, 0, 0, 0);

    public DragTree(File file, final JFrame jFrame, final JembossParams jembossParams) {
        this.mysettings = jembossParams;
        this.root = file;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
        DefaultTreeModel defaultTreeModel = this.createTreeModel(this.root);
        this.setModel(defaultTreeModel);
        this.createTreeModelListener();
        this.getSelectionModel().setSelectionMode(4);
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Refresh");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.add(new JSeparator());
        JMenu jMenu = new JMenu("Open With");
        this.popup.add(jMenu);
        jMenuItem = new JMenuItem("Jemboss Alignment Editor");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Text Editor");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename...");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("New Folder...");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete...");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.add(new JSeparator());
        jMenuItem = new JMenuItem("De-select All");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && DragTree.this.isFileSelection() && !mouseEvent.isPopupTrigger()) {
                    jFrame.setCursor(DragTree.this.cbusy);
                    FileNode fileNode = DragTree.this.getSelectedNode();
                    String string = fileNode.getFile().getAbsolutePath();
                    DragTree.showFilePane(string, jembossParams);
                    jFrame.setCursor(DragTree.this.cdone);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                FileNode fileNode;
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath != null && !(fileNode = (FileNode)treePath.getLastPathComponent()).isExplored()) {
                    jFrame.setCursor(DragTree.this.cbusy);
                    DragTree.this.exploreNode(fileNode);
                    jFrame.setCursor(DragTree.this.cdone);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block15: {
            String string;
            File file;
            FileNode fileNode;
            JMenuItem jMenuItem;
            block19: {
                block18: {
                    int n;
                    block17: {
                        block16: {
                            block14: {
                                jMenuItem = (JMenuItem)actionEvent.getSource();
                                fileNode = this.getSelectedNode();
                                if (jMenuItem.getText().equals("Refresh")) {
                                    if (fileNode == null) {
                                        this.newRoot(this.root.getAbsolutePath());
                                    } else if (fileNode.isLeaf()) {
                                        this.refresh((FileNode)fileNode.getParent());
                                    } else {
                                        this.refresh(fileNode);
                                    }
                                    return;
                                }
                                if (fileNode == null) {
                                    JOptionPane.showMessageDialog(null, "No file selected.", "Warning", 2);
                                    return;
                                }
                                file = fileNode.getFile();
                                if (!jMenuItem.getText().equals("Jemboss Alignment Editor")) break block14;
                                AlignJFrame alignJFrame = new AlignJFrame(file);
                                alignJFrame.setVisible(true);
                                break block15;
                            }
                            if (!jMenuItem.getText().equals("Text Editor")) break block16;
                            DragTree.showFilePane(file.getAbsolutePath(), this.mysettings);
                            break block15;
                        }
                        if (!jMenuItem.getText().equals("New Folder...")) break block17;
                        String string2 = null;
                        string2 = fileNode.isLeaf() ? file.getParent() : file.getAbsolutePath();
                        String string3 = JOptionPane.showInputDialog(null, "Folder Name", "Create New Folder in " + string2, 3);
                        if (string3 == null || string3.equals("")) break block15;
                        String string4 = string2 + this.fs + string3;
                        File file2 = new File(string4);
                        if (file2.exists()) {
                            JOptionPane.showMessageDialog(null, string4 + " alread exists!", "Error", 0);
                        } else if (file2.mkdir()) {
                            this.addObject(string3, string2, fileNode);
                        } else {
                            JOptionPane.showMessageDialog(null, "Cannot make the folder\n" + string4, "Error", 0);
                        }
                        break block15;
                    }
                    if (!jMenuItem.getText().equals("Delete...")) break block18;
                    File[] fileArray = this.getSelectedFiles();
                    String string5 = "";
                    for (n = 0; n < fileArray.length; ++n) {
                        string5 = string5.concat(fileArray[n].getAbsolutePath() + "\n");
                    }
                    n = JOptionPane.showConfirmDialog(null, "Delete \n" + string5 + "?", "Delete Files", 0);
                    FileNode[] fileNodeArray = this.getSelectedNodes();
                    if (n != 0) break block15;
                    for (int i = 0; i < fileNodeArray.length; ++i) {
                        this.deleteFile(fileNodeArray[i]);
                    }
                    break block15;
                }
                if (!jMenuItem.getText().equals("De-select All")) break block19;
                this.clearSelection();
                break block15;
            }
            if (!this.isFileSelection() || !jMenuItem.getText().equals("Rename...") || (string = (String)JOptionPane.showInputDialog(null, "New File Name", "Rename " + file.getName(), 3, null, null, file.getName())) == null || string.equals("")) break block15;
            String string6 = file.getParent();
            String string7 = string6 + this.fs + string;
            File file3 = new File(string7);
            try {
                this.renameFile(file, fileNode, file3.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void deleteFile(final FileNode fileNode) {
        File file = fileNode.getFile();
        if (file.delete()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    DragTree.this.deleteObject(fileNode);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            JOptionPane.showMessageDialog(null, "Cannot delete\n" + file.getAbsolutePath(), "Warning", 0);
        }
    }

    private void renameFile(File file, final FileNode fileNode, String string) {
        final File file2 = new File(string);
        if (file2.exists()) {
            JOptionPane.showMessageDialog(null, string + " alread exists!", "Warning", 0);
        } else if (file.renameTo(file2)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    DragTree.this.addObject(file2.getName(), file2.getParent(), fileNode);
                    DragTree.this.deleteObject(fileNode);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            JOptionPane.showMessageDialog(null, "Cannot rename \n" + file.getAbsolutePath() + "\nto\n" + file2.getAbsolutePath(), "Rename Error", 0);
        }
    }

    public void newRoot(String string) {
        this.root = new File(string);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel = this.createTreeModel(this.root);
        this.setModel(defaultTreeModel);
    }

    public void refresh(FileNode fileNode) {
        fileNode.reExplore();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.nodeStructureChanged(fileNode);
    }

    public FileNode getSelectedNode() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath == null) {
            return null;
        }
        FileNode fileNode = (FileNode)treePath.getLastPathComponent();
        return fileNode;
    }

    public FileNode[] getSelectedNodes() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        int n = treePathArray.length;
        FileNode[] fileNodeArray = new FileNode[n];
        for (int i = 0; i < n; ++i) {
            fileNodeArray[i] = (FileNode)treePathArray[i].getLastPathComponent();
        }
        return fileNodeArray;
    }

    public File[] getSelectedFiles() {
        FileNode[] fileNodeArray = this.getSelectedNodes();
        int n = fileNodeArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = fileNodeArray[i].getFile();
        }
        return fileArray;
    }

    public boolean isFileSelection() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath == null) {
            return false;
        }
        FileNode fileNode = (FileNode)treePath.getLastPathComponent();
        return fileNode.isLeaf();
    }

    private DefaultTreeModel createTreeModel(File file) {
        FileNode fileNode = new FileNode(file);
        fileNode.explore();
        this.openNode = new Vector();
        this.openNode.add(fileNode);
        return new DefaultTreeModel(fileNode);
    }

    public DefaultMutableTreeNode addObject(String string, String string2, FileNode fileNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        if (fileNode == null && (fileNode = this.getNode(string2)) == null) {
            return null;
        }
        FileNode fileNode2 = this.getNode(string2);
        File file = new File(string2 + this.fs + string);
        FileNode fileNode3 = null;
        if (fileNode2.isExplored()) {
            fileNode3 = new FileNode(file);
            int n = this.getAnIndex(fileNode2, string);
            if (n > -1) {
                defaultTreeModel.insertNodeInto(fileNode3, fileNode2, n);
            }
        } else if (fileNode2.isDirectory()) {
            this.exploreNode(fileNode2);
            fileNode3 = this.getNode(string2 + this.fs + string);
        }
        this.scrollPathToVisible(new TreePath(fileNode3.getPath()));
        return fileNode3;
    }

    public void deleteObject(FileNode fileNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        FileNode fileNode2 = this.getNode(fileNode.getFile().getParent());
        defaultTreeModel.removeNodeFromParent(fileNode);
    }

    public void exploreNode(FileNode fileNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        fileNode.explore();
        this.openNode.add(fileNode);
        defaultTreeModel.nodeStructureChanged(fileNode);
    }

    private FileNode getNode(String string) {
        FileNode fileNode;
        Enumeration enumeration = this.openNode.elements();
        while (enumeration.hasMoreElements()) {
            fileNode = (FileNode)enumeration.nextElement();
            String string2 = fileNode.getFile().getAbsolutePath();
            if (!string2.equals(string)) continue;
            return fileNode;
        }
        enumeration = this.openNode.elements();
        while (enumeration.hasMoreElements()) {
            fileNode = this.getChildNode((FileNode)enumeration.nextElement(), string);
            if (fileNode == null) continue;
            return fileNode;
        }
        return null;
    }

    private FileNode getChildNode(FileNode fileNode, String string) {
        Enumeration<TreeNode> enumeration = fileNode.children();
        while (enumeration.hasMoreElements()) {
            FileNode fileNode2 = (FileNode)enumeration.nextElement();
            String string2 = fileNode2.getFile().getAbsolutePath();
            if (!string.equals(string2)) continue;
            return fileNode2;
        }
        return null;
    }

    private int getAnIndex(FileNode fileNode, String string) {
        int n;
        int n2 = n = fileNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            String string2 = ((FileNode)fileNode.getChildAt(i)).getFile().getName();
            if (string2.compareTo(string) > 0) {
                n2 = i;
                break;
            }
            if (string2.compareTo(string) != 0) continue;
            n2 = -1;
            break;
        }
        return n2;
    }

    protected static byte[] readByteFile(String string) {
        File file = new File(string);
        byte[] byArray = null;
        try {
            long l = file.length();
            if (l == 0L) {
                return byArray;
            }
            byArray = new byte[(int)l];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file: " + string);
        }
        return byArray;
    }

    public static void showFilePane(String string, JembossParams jembossParams) {
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
        hashtable.put(string, DragTree.readByteFile(string));
        ShowResultSet showResultSet = new ShowResultSet(hashtable, jembossParams);
        showResultSet.setTitle("Local File");
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).isPopupTrigger()) {
            return;
        }
        if (this.isFileSelection()) {
            dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, this.getSelectedNode(), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE) || dropTargetDragEvent.isDataFlavorSupported(FileNode.FILENODE)) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        final FileNode fileNode = this.getSelectedNode();
        if (fileNode == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        if (transferable.isDataFlavorSupported(FileNode.FILENODE)) {
            try {
                FileNode fileNode2 = (FileNode)transferable.getTransferData(FileNode.FILENODE);
                fileNode2 = this.getNode(fileNode2.getFile().getAbsolutePath());
                if (fileNode.isLeaf()) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                String string = fileNode.getFile().getAbsolutePath();
                String string2 = string + this.fs + fileNode2.toString();
                this.renameFile(fileNode2.getFile(), fileNode2, string2);
            }
            catch (Exception exception) {}
        } else {
            if (transferable.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
                try {
                    Object object;
                    final RemoteFileNode remoteFileNode = (RemoteFileNode)transferable.getTransferData(RemoteFileNode.REMOTEFILENODE);
                    File file = null;
                    String string = null;
                    if (fileNode.isLeaf()) {
                        object = (FileNode)fileNode.getParent();
                        string = ((FileNode)object).getFile().getAbsolutePath();
                        file = new File(string, remoteFileNode.getFile());
                    } else {
                        string = fileNode.getFile().getAbsolutePath();
                        file = new File(string, remoteFileNode.getFile());
                    }
                    try {
                        this.setCursor(this.cbusy);
                        object = new FileSave(file);
                        if (((FileSave)object).doWrite()) {
                            Vector<String> vector = new Vector<String>();
                            vector.addElement("fileroot=" + remoteFileNode.getRootDir());
                            vector.addElement(remoteFileNode.getFullName());
                            PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "get_file", vector);
                            ((FileSave)object).fileSaving(privateRequest.getHash().get("contents"));
                            if (((FileSave)object).writeOK() && !((FileSave)object).fileExists()) {
                                final String string3 = string;
                                Runnable runnable = new Runnable(){

                                    public void run() {
                                        DragTree.this.addObject(remoteFileNode.getFile(), string3, fileNode);
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                        this.setCursor(this.cdone);
                    }
                    catch (Exception exception) {
                        this.setCursor(this.cdone);
                        System.out.println("DragTree: caught exception");
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                }
                catch (Exception exception) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
            }
            dropTargetDropEvent.rejectDrop();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
            } else {
                this.setSelectionPath(treePath);
                dropTargetDragEvent.acceptDrag(3);
            }
        } else if (dropTargetDragEvent.isDataFlavorSupported(FileNode.FILENODE)) {
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            FileNode fileNode = (FileNode)treePath.getLastPathComponent();
            if (!fileNode.isDirectory()) {
                dropTargetDragEvent.rejectDrag();
            } else {
                this.setSelectionPath(treePath);
                dropTargetDragEvent.acceptDrag(3);
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void autoscroll(Point point) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getVisibleRect();
        int n5 = rectangle.y + rectangle.height;
        int n6 = rectangle.x + rectangle.width;
        if (point.y - rectangle.y < 45 && rectangle.y > 0) {
            n = 45;
        }
        if (point.x - rectangle.x < 45 && rectangle.x > 0) {
            n2 = 45;
        }
        if (n5 - point.y < 45 && n5 < dimension.height) {
            n3 = 45;
        }
        if (n6 - point.x < 45 && n6 < dimension.width) {
            n4 = 45;
        }
        rectangle.x += n4 - n2;
        rectangle.y += n3 - n;
        this.scrollRectToVisible(rectangle);
    }

    public Insets getAutoscrollInsets() {
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getVisibleRect();
        this.autoscrollInsets.top = rectangle.y + 45;
        this.autoscrollInsets.left = rectangle.x + 45;
        this.autoscrollInsets.bottom = dimension.height - (rectangle.y + rectangle.height) + 45;
        this.autoscrollInsets.right = dimension.width - (rectangle.x + rectangle.width) + 45;
        return this.autoscrollInsets;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DragTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

