/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.ui;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressIndicator;
import com.vaadin.ui.VerticalLayout;
import fi.csc.microarray.manager.web.ChipsterAdminUI;
import fi.csc.microarray.manager.web.data.StorageAggregate;
import fi.csc.microarray.manager.web.data.StorageAggregateContainer;
import fi.csc.microarray.manager.web.data.StorageEntryContainer;
import fi.csc.microarray.manager.web.ui.StorageAggregateTable;
import fi.csc.microarray.manager.web.ui.StorageEntryTable;
import fi.csc.microarray.manager.web.util.StringUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;

public class StorageView
extends VerticalLayout
implements Button.ClickListener,
Property.ValueChangeListener {
    private static final String DISK_USAGE_BAR_CAPTION = "Total disk usage";
    private StorageEntryTable entryTable;
    private StorageAggregateTable aggregateTable;
    private HorizontalLayout toolbarLayout;
    private Button refreshButton = new Button("Refresh");
    private StorageEntryContainer entryDataSource;
    private StorageAggregateContainer aggregateDataSource;
    private ChipsterAdminUI app;
    private ProgressIndicator diskUsageBar;
    private HorizontalLayout storagePanels;
    private ProgressIndicator progressIndicator = new ProgressIndicator(Float.valueOf(0.0f));
    private boolean updateDone;
    private static final int POLLING_INTERVAL = 100;

    public StorageView(ChipsterAdminUI app) {
        this.app = app;
        this.addComponent((Component)this.getToolbar());
        this.progressIndicator.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.addComponent((Component)this.progressIndicator);
        this.entryTable = new StorageEntryTable(this);
        this.aggregateTable = new StorageAggregateTable(this);
        HorizontalLayout aggregatePanelLayout = new HorizontalLayout();
        HorizontalLayout entryPanelLayout = new HorizontalLayout();
        aggregatePanelLayout.setSizeFull();
        entryPanelLayout.setSizeFull();
        aggregatePanelLayout.addComponent((Component)this.aggregateTable);
        entryPanelLayout.addComponent((Component)this.entryTable);
        aggregatePanelLayout.setExpandRatio((Component)this.aggregateTable, 1.0f);
        entryPanelLayout.setExpandRatio((Component)this.entryTable, 1.0f);
        Panel aggregatePanel = new Panel("Disk usage by user");
        Panel entryPanel = new Panel("Stored sessions");
        aggregatePanel.setWidth(300.0f, Sizeable.Unit.PIXELS);
        aggregatePanel.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        entryPanel.setSizeFull();
        aggregatePanel.setContent((ComponentContainer)aggregatePanelLayout);
        entryPanel.setContent((ComponentContainer)entryPanelLayout);
        this.storagePanels = new HorizontalLayout();
        this.storagePanels.setSizeFull();
        this.storagePanels.addComponent((Component)aggregatePanel);
        this.storagePanels.addComponent((Component)entryPanel);
        this.storagePanels.setExpandRatio((Component)entryPanel, 1.0f);
        this.setSizeFull();
        this.addComponent((Component)this.storagePanels);
        this.setExpandRatio((Component)this.storagePanels, 1.0f);
        try {
            this.entryDataSource = new StorageEntryContainer();
            this.aggregateDataSource = new StorageAggregateContainer(this.entryDataSource);
            this.entryTable.setContainerDataSource((Container)this.entryDataSource);
            this.aggregateTable.setContainerDataSource((Container)this.aggregateDataSource);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void update() {
        this.entryDataSource.update(this);
        this.refreshButton.setEnabled(false);
        this.updateDone = false;
        this.progressIndicator.setPollingInterval(100);
        ExecutorService execService = Executors.newCachedThreadPool();
        execService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int DELAY = 300;
                    for (int i = 0; i <= 300; ++i) {
                        if (StorageView.this.updateDone) {
                            break;
                        }
                        if (StorageView.this.progressIndicator.getUI() != null && StorageView.this.progressIndicator.getUI().getSession().getLock() != null) {
                            StorageView.this.progressIndicator.getUI().getSession().getLock().lock();
                            try {
                                StorageView.this.progressIndicator.setValue((Object)Float.valueOf((float)i / 300.0f));
                            }
                            finally {
                                StorageView.this.progressIndicator.getUI().getSession().getLock().unlock();
                            }
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    StorageView.this.refreshButton.setEnabled(true);
                    StorageView.this.progressIndicator.getUI().getSession().getLock().lock();
                    try {
                        StorageView.this.progressIndicator.setValue((Object)Float.valueOf(1.0f));
                        StorageView.this.progressIndicator.setPollingInterval(Integer.MAX_VALUE);
                    }
                    finally {
                        StorageView.this.progressIndicator.getUI().getSession().getLock().unlock();
                    }
                }
            }
        });
    }

    private void updateDiskUsageBar() {
        long used = this.aggregateDataSource.getDiskUsage();
        long total = this.aggregateDataSource.getDiskAvailable() + used;
        this.diskUsageBar.setValue((Object)Float.valueOf((float)used / (float)total));
        this.diskUsageBar.setCaption("Total disk usage ( " + StringUtils.getHumanReadable(used) + " / " + StringUtils.getHumanReadable(total) + " )");
        if ((double)((float)used / (float)total) > 0.7) {
            this.diskUsageBar.removeStyleName("ok");
            this.diskUsageBar.addStyleName("fail");
        } else {
            this.diskUsageBar.removeStyleName("fail");
            this.diskUsageBar.addStyleName("ok");
        }
        this.diskUsageBar.markAsDirty();
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            this.refreshButton.addClickListener((Button.ClickListener)this);
            this.toolbarLayout.addComponent((Component)this.refreshButton);
            this.refreshButton.setIcon((Resource)new ThemeResource("../runo/icons/32/reload.png"));
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.diskUsageBar = new ProgressIndicator(Float.valueOf(0.0f));
            this.diskUsageBar.setCaption(DISK_USAGE_BAR_CAPTION);
            this.diskUsageBar.setStyleName("big");
            this.diskUsageBar.setPollingInterval(Integer.MAX_VALUE);
            this.diskUsageBar.setWidth(300.0f, Sizeable.Unit.PIXELS);
            this.toolbarLayout.addComponent((Component)this.diskUsageBar);
            this.toolbarLayout.setExpandRatio((Component)this.diskUsageBar, 1.0f);
            this.toolbarLayout.addComponent(this.app.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    public void buttonClick(Button.ClickEvent event) {
        Button source = event.getButton();
        if (source == this.refreshButton) {
            this.update();
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Property property = event.getProperty();
        if (property == this.aggregateTable) {
            this.updateEntryFilter();
            StorageAggregate selection = (StorageAggregate)this.aggregateTable.getValue();
            if (this.aggregateDataSource.TOTAL_USERNAME.equals(selection.getUsername())) {
                this.entryDataSource.showUser(null);
            }
        }
    }

    public void updateEntryFilter() {
        StorageAggregate selection = (StorageAggregate)this.aggregateTable.getValue();
        if (this.aggregateDataSource.TOTAL_USERNAME.equals(selection.getUsername())) {
            this.entryDataSource.showUser(null);
        } else {
            this.entryDataSource.showUser(selection.getUsername());
        }
    }

    public ChipsterAdminUI getApp() {
        return this.app;
    }

    public void delete(Object itemId) {
        this.entryDataSource.removeItem(itemId);
        this.aggregateDataSource.update(this);
        this.updateEntryFilter();
        this.updateDiskUsageBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryUpdateDone() {
        Lock entryTableLock = this.entryTable.getUI().getSession().getLock();
        entryTableLock.lock();
        try {
            this.entryTable.setVisibleColumns(StorageEntryContainer.NATURAL_COL_ORDER);
            this.entryTable.setColumnHeaders(StorageEntryContainer.COL_HEADERS_ENGLISH);
        }
        finally {
            entryTableLock.unlock();
        }
        Lock aggregateTableLock = this.aggregateTable.getUI().getSession().getLock();
        aggregateTableLock.lock();
        try {
            StorageAggregate totalItem = this.aggregateDataSource.update(this);
            this.aggregateTable.select(totalItem);
            this.aggregateTable.setVisibleColumns(StorageAggregateContainer.NATURAL_COL_ORDER);
            this.aggregateTable.setColumnHeaders(StorageAggregateContainer.COL_HEADERS_ENGLISH);
        }
        finally {
            aggregateTableLock.unlock();
        }
        Lock proggressIndicatorLock = this.progressIndicator.getUI().getSession().getLock();
        proggressIndicatorLock.lock();
        try {
            this.updateDiskUsageBar();
        }
        finally {
            proggressIndicatorLock.unlock();
        }
        this.updateDone = true;
    }

    public AbstractClientConnector getEntryTable() {
        return this.entryTable;
    }
}

