/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import fi.csc.microarray.manager.web.data.JobLogEntry;
import fi.csc.microarray.manager.web.data.StatDataSource;
import fi.csc.microarray.manager.web.hbncontainer.HibernateUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.exception.GenericJDBCException;

public class StatView
extends HorizontalLayout
implements Button.ClickListener {
    private Button testButton;
    private Panel latestJobsPanel = new Panel("Latest jobs");
    private Panel jobCountsPanel = new Panel("Job counts monthly");
    private Panel topUsersPanel = new Panel("Top users during last year");
    private Panel toolFailsPanel = new Panel("Tool fails during last year");
    private Table latestJobsTable;
    private Table jobCountsTable;
    private Table topUsersTable;
    private Table toolFailsTable;

    public StatView() {
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
        }
        catch (GenericJDBCException e) {
            e.printStackTrace();
            return;
        }
        StatDataSource dataSource = new StatDataSource();
        this.latestJobsTable = this.JobLogEntryToTable(dataSource.getLatestJobs(session));
        this.jobCountsTable = this.mapListToTable(dataSource.getJobsByMonth(session));
        this.topUsersTable = this.mapListToTable(dataSource.getTopUsers(session));
        this.toolFailsTable = this.mapListToTable(dataSource.getToolFails(session));
        this.jobCountsTable.setVisibleColumns(dataSource.getJobsByMonthColumnOrder());
        this.topUsersTable.setVisibleColumns(dataSource.getTopUsersColumnOrder());
        this.toolFailsTable.setVisibleColumns(dataSource.getToolFailsColumnOrder());
        this.latestJobsPanel.addComponent((Component)this.latestJobsTable);
        this.jobCountsPanel.addComponent((Component)this.jobCountsTable);
        this.topUsersPanel.addComponent((Component)this.topUsersTable);
        this.toolFailsPanel.addComponent((Component)this.toolFailsTable);
        this.latestJobsPanel.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.jobCountsPanel.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.topUsersPanel.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.toolFailsPanel.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.addComponent((Component)this.latestJobsPanel);
        this.addComponent((Component)this.jobCountsPanel);
        this.addComponent((Component)this.topUsersPanel);
        this.addComponent((Component)this.toolFailsPanel);
        this.setSizeFull();
    }

    private Table JobLogEntryToTable(List<JobLogEntry> list) {
        Table table = new Table();
        table.setSizeFull();
        if (list.size() > 0) {
            List<Object> keyList = Arrays.asList("username", "operation", "startTime", "status");
            for (Object columnHeader : keyList) {
                table.addContainerProperty(columnHeader, String.class, null);
            }
            int i = 0;
            for (JobLogEntry entry : list) {
                table.addItem(new Object[]{entry.getUsername(), entry.getOperation(), entry.getStartTime().toString(), entry.getStatus()}, (Object)i++);
            }
        }
        return table;
    }

    private Table mapListToTable(List<Map<Object, Object>> list) {
        Table table = new Table();
        table.setSizeFull();
        if (list.size() > 0) {
            LinkedList<Object> keyList = new LinkedList<Object>(list.get(0).keySet());
            for (Object e : keyList) {
                table.addContainerProperty(e, String.class, null);
            }
            int i = 0;
            for (Map<Object, Object> map : list) {
                LinkedList<String> stringValues = new LinkedList<String>();
                for (Object objValue : map.values()) {
                    if (objValue != null) {
                        stringValues.add(objValue.toString());
                        continue;
                    }
                    stringValues.add("");
                }
                table.addItem(stringValues.toArray(), (Object)i++);
            }
        }
        return table;
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.testButton) {
            // empty if block
        }
    }
}

