/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.ui;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import fi.csc.microarray.manager.web.ChipsterAdminUI;
import fi.csc.microarray.manager.web.data.JobLogContainer;
import fi.csc.microarray.manager.web.ui.JobLogSearch;
import fi.csc.microarray.manager.web.ui.JobLogTable;
import java.util.LinkedList;
import org.hibernate.exception.GenericJDBCException;

public class JobLogView
extends VerticalLayout
implements Button.ClickListener,
Property.ValueChangeListener {
    private HorizontalLayout toolbarLayout;
    private Button addSearchButton = new Button();
    private JobLogTable table;
    private JobLogContainer dataSource;
    private ChipsterAdminUI app;
    private LinkedList<JobLogSearch> searches;
    private HorizontalLayout searchLayout;

    public JobLogView(ChipsterAdminUI app) {
        this.app = app;
        this.init();
    }

    public void init() {
        try {
            this.dataSource = new JobLogContainer(this);
            this.table = new JobLogTable(this);
            this.table.setContainerDataSource((Container)this.dataSource);
        }
        catch (GenericJDBCException e) {
            return;
        }
        this.table.setVisibleColumns(JobLogContainer.NATURAL_COL_ORDER);
        this.table.setColumnHeaders(JobLogContainer.COL_HEADERS_ENGLISH);
        this.addComponent((Component)this.getToolbar());
        this.addComponent((Component)this.table);
        this.setSizeFull();
        this.setExpandRatio((Component)this.table, 1.0f);
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            this.searchLayout = new HorizontalLayout();
            this.addSearch();
            this.toolbarLayout.addComponent((Component)this.searchLayout);
            this.addSearchButton.addClickListener((Button.ClickListener)this);
            this.addSearchButton.setIcon((Resource)new ThemeResource("crystal/edit_add.png"));
            this.addSearchButton.setDescription("Add another search");
            this.addSearchButton.addStyleName("search-button");
            HorizontalLayout buttonBorder = new HorizontalLayout();
            buttonBorder.addStyleName("search-filter");
            buttonBorder.addComponent((Component)this.addSearchButton);
            this.toolbarLayout.addComponent((Component)buttonBorder);
            Button searchButton = new Button();
            searchButton.setIcon((Resource)new ThemeResource("crystal/mail_find.png"));
            searchButton.setDescription("Search");
            this.toolbarLayout.addComponent((Component)searchButton);
            searchButton.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    JobLogView.this.performSearch();
                }
            });
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.toolbarLayout.addComponent(this.app.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    private void addSearch() {
        if (this.searches == null) {
            this.searches = new LinkedList();
        }
        JobLogSearch search = new JobLogSearch(this);
        this.searches.add(search);
        this.searchLayout.addComponent((Component)search);
    }

    public void buttonClick(Button.ClickEvent event) {
        Button source = event.getButton();
        if (source == this.addSearchButton) {
            this.addSearch();
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Property property = event.getProperty();
        if (property == this.table) {
            // empty if block
        }
    }

    public void performSearch() {
        this.updateContainerFilters();
        Notification.show((String)("Found " + this.table.getContainerDataSource().size() + " item(s)"), (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
    }

    private void updateContainerFilters() {
        this.dataSource.removeAllContainerFilters();
        for (JobLogSearch iteratedSearch : this.searches) {
            if (iteratedSearch.getContainerFilter() == null) continue;
            this.dataSource.addContainerFilter(iteratedSearch.getContainerFilter());
        }
    }

    public void clearSearch(JobLogSearch search) {
        if (this.searches.size() > 1) {
            this.searchLayout.removeComponent((Component)search);
            this.searches.remove((Object)search);
        } else {
            this.searches.get(0).clear();
        }
        this.updateContainerFilters();
    }

    public void showOutput(Object itemId) {
        String output = "";
        Property outputProperty = this.dataSource.getContainerProperty(itemId, "outputText");
        if (outputProperty != null) {
            output = (String)outputProperty.getValue();
        }
        this.showTextWindow("Job output", output);
    }

    public void showErrorOutput(Object itemId) {
        String error = "";
        Property errorProperty = this.dataSource.getContainerProperty(itemId, "errorMessage");
        if (errorProperty != null) {
            error = (String)errorProperty.getValue();
        }
        this.showTextWindow("Error message", error);
    }

    private void showTextWindow(String caption, String content) {
        Label textComponent = new Label(content);
        textComponent.setContentMode(ContentMode.PREFORMATTED);
        Window subWindow = new Window(caption);
        subWindow.addComponent((Component)textComponent);
        subWindow.setWidth(70.0f, Sizeable.Unit.PIXELS);
        subWindow.setHeight(90.0f, Sizeable.Unit.PIXELS);
        subWindow.center();
        this.addComponent((Component)subWindow);
    }
}

